% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FitSerial_class.R
\name{FitSerial}
\alias{FitSerial}
\alias{print.FitSerial}
\alias{coef.FitSerial}
\alias{summary.FitSerial}
\alias{predict.FitSerial}
\alias{residuals.FitSerial}
\alias{vcov.FitSerial}
\alias{deviance.FitSerial}
\alias{fitted.FitSerial}
\alias{logLik.FitSerial}
\alias{AIC.FitSerial}
\alias{plot.FitSerial}
\title{FitSerial class}
\usage{
\method{print}{FitSerial}(x, ...)

\method{coef}{FitSerial}(object, ...)

\method{summary}{FitSerial}(object, ...)

\method{predict}{FitSerial}(object, newdata = NULL, ...)

\method{residuals}{FitSerial}(object, ...)

\method{vcov}{FitSerial}(object, ...)

\method{deviance}{FitSerial}(object, ...)

\method{fitted}{FitSerial}(object, ...)

\method{logLik}{FitSerial}(object, ...)

\method{AIC}{FitSerial}(object, ..., k = 2)

\method{plot}{FitSerial}(
  x,
  y = NULL,
  ...,
  line_col = "black",
  line_size = 1,
  line_type = 1,
  point_col = "black",
  point_size = 3,
  point_shape = 16,
  label_y = NULL,
  label_x = NULL
)
}
\arguments{
\item{x}{The object of class \link{FitSerial} to plot.}

\item{...}{ignored.}

\item{object}{an instance of FitSerial}

\item{newdata}{tibble (or data.frame) with the conditions for the prediction.
If \code{NULL} (default), the fitting conditions.}

\item{k}{penalty for the parameters (k=2 by default)}

\item{y}{ignored}

\item{line_col}{colour of the line}

\item{line_size}{size of the line}

\item{line_type}{type of the line}

\item{point_col}{colour of the points}

\item{point_size}{size of the points}

\item{point_shape}{shape of the point}

\item{label_y}{label for the y-axis. By default, \code{NULL} (default value depending on the mode)}

\item{label_x}{label for the x-axis. By default, \code{NULL} (default value depending on the mode)}
}
\description{
The \code{FitSerial} class contains growth rates estimated using the
function \code{\link[=fit_serial_dilution]{fit_serial_dilution()}}.

It is a subclass of list with the items:
\itemize{
\item fit: object returned by \code{\link[=nls]{nls()}}.
\item mode: fitting approach.
\item data: data used for the model fitting.
}
}
\section{Methods (by generic)}{
\itemize{
\item \code{print(FitSerial)}: print of the model

\item \code{coef(FitSerial)}: vector of fitted model parameters.

\item \code{summary(FitSerial)}: statistical summary of the fit.

\item \code{predict(FitSerial)}: vector of model predictions.

\item \code{residuals(FitSerial)}: vector of model residuals.

\item \code{vcov(FitSerial)}: variance-covariance matrix of the model

\item \code{deviance(FitSerial)}: deviance of the model.

\item \code{fitted(FitSerial)}: vector of fitted values.

\item \code{logLik(FitSerial)}: loglikelihood of the model

\item \code{AIC(FitSerial)}: Akaike Information Criterion

\item \code{plot(FitSerial)}: compares the fitted model against the data.

}}
