% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FitCoupledGrowth_class.R,
%   R/predictMCMC_coupled.R
\name{FitCoupledGrowth}
\alias{FitCoupledGrowth}
\alias{print.FitCoupledGrowth}
\alias{coef.FitCoupledGrowth}
\alias{summary.FitCoupledGrowth}
\alias{predict.FitCoupledGrowth}
\alias{residuals.FitCoupledGrowth}
\alias{vcov.FitCoupledGrowth}
\alias{deviance.FitCoupledGrowth}
\alias{fitted.FitCoupledGrowth}
\alias{logLik.FitCoupledGrowth}
\alias{AIC.FitCoupledGrowth}
\alias{plot.FitCoupledGrowth}
\alias{predictMCMC_coupled.FitCoupledGrowth}
\title{FitCoupledGrowth class}
\usage{
\method{print}{FitCoupledGrowth}(x, ...)

\method{coef}{FitCoupledGrowth}(object, ...)

\method{summary}{FitCoupledGrowth}(object, ...)

\method{predict}{FitCoupledGrowth}(object, newdata = NULL, ...)

\method{residuals}{FitCoupledGrowth}(object, ...)

\method{vcov}{FitCoupledGrowth}(object, ...)

\method{deviance}{FitCoupledGrowth}(object, ...)

\method{fitted}{FitCoupledGrowth}(object, ...)

\method{logLik}{FitCoupledGrowth}(object, ...)

\method{AIC}{FitCoupledGrowth}(object, ..., k = 2)

\method{plot}{FitCoupledGrowth}(
  x,
  y = NULL,
  ...,
  line_col = "black",
  line_size = 1,
  line_type = 1,
  point_col = "black",
  point_size = 3,
  point_shape = 16,
  label_y = NULL,
  label_x = NULL
)

\method{predictMCMC_coupled}{FitCoupledGrowth}(model, niter, newdata = NULL, includecorr = TRUE)
}
\arguments{
\item{x}{The object of class \link{FitCoupledGrowth} to plot.}

\item{...}{ignored.}

\item{object}{an instance of FitCoupledGrowth}

\item{newdata}{a data.frame (or tibble) describing experimental conditions. If null,
the ones used for the fitting are used (default).}

\item{k}{penalty for the parameters (k=2 by default)}

\item{y}{ignored}

\item{line_col}{colour of the line}

\item{line_size}{size of the line}

\item{line_type}{type of the line}

\item{point_col}{colour of the points}

\item{point_size}{size of the points}

\item{point_shape}{shape of the point}

\item{label_y}{label for the y-axis. By default, \code{NULL} (default value depending on the mode)}

\item{label_x}{label for the x-axis. By default, \code{NULL} (default value depending on the mode)}

\item{model}{an instance of FitCoupledGrowth}

\item{niter}{Number of MCMC iterations}

\item{includecorr}{whether to include parameter correlation (\code{TRUE} by default)}
}
\description{
The \code{FitCoupledGrowth} class contains a Baranyi model fitted to experimental data
considering the coupling between the primary and secondary models.
Its constructor is \code{\link[=fit_coupled_growth]{fit_coupled_growth()}}.

It is a subclass of list with the items:
\itemize{
\item fit: object returned by \code{\link[FME:modFit]{FME::modFit()}}.
\item mode: fitting approach.
\item weight: type of weights for the two-steps approach.
\item logbase_mu: base of the logarithm used for the calculation of mu.
\item data: data used for the model fitting.
}
}
\section{Methods (by generic)}{
\itemize{
\item \code{print(FitCoupledGrowth)}: print of the model

\item \code{coef(FitCoupledGrowth)}: vector of fitted model parameters.

\item \code{summary(FitCoupledGrowth)}: statistical summary of the fit.

\item \code{predict(FitCoupledGrowth)}: vector of model predictions.

\item \code{residuals(FitCoupledGrowth)}: vector of model residuals.

\item \code{vcov(FitCoupledGrowth)}: variance-covariance matrix of the model, estimated
as 1/(0.5*Hessian) for regression

\item \code{deviance(FitCoupledGrowth)}: deviance of the model.

\item \code{fitted(FitCoupledGrowth)}: vector of fitted values.

\item \code{logLik(FitCoupledGrowth)}: loglikelihood of the model

\item \code{AIC(FitCoupledGrowth)}: Akaike Information Criterion

\item \code{plot(FitCoupledGrowth)}: compares the fitted model against the data.

\item \code{predictMCMC_coupled(FitCoupledGrowth)}: prediction including parameter uncertainty

}}
