% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bins.R
\name{bins}
\alias{bins}
\title{Cut Numeric Values Into Evenly Distributed Groups (Bins)}
\usage{
bins(
  x,
  target.bins,
  max.breaks = NA,
  exact.groups = F,
  verbose = F,
  errthresh = 0.1,
  minpts = NA
)
}
\arguments{
\item{x}{Vector of numbers}

\item{target.bins}{Number of groups desired; this is also the max number of groups.}

\item{max.breaks}{Used for initial cut. If \code{exact.groups} is \code{FALSE}, bins are merged
until there's no bins with fewer than \code{length(x) / max.breaks} points.
In \code{bins}, one of \code{max.breaks} and \code{minpts} must be supplied.}

\item{exact.groups}{if TRUE, the result will have exactly the number of target.bins;
if FALSE, the result may contain fewer than target.bins bins}

\item{verbose}{Indicates verbose output.}

\item{errthresh}{If the error is below the provided value, stops after the first rough estimate of the bins.}

\item{minpts}{Minimum number of points in a bin.
In \code{bins}, one of \code{max.breaks} and \code{minpts} must be supplied.}
}
\value{
A list containing the following items (not all of them may be present):
\describe{
\item{binlo}{ - The index into \code{xval} yielding the "low" value falling into the bin.}
\item{binhi}{ - The index into \code{xval} yielding the "high" value falling into the bin.}
\item{binct}{ - The number of points falling into the bin.}
\item{xtbl}{ - The result of a call to \code{table(x)}.}
\item{xval}{ - The sorted unique values of the data points x. Essentially, a numeric version of \code{names(xtbl)}.}
\item{changed}{ - Flag indicating whether the bins have been modified by the function.}
\item{err}{ - Mean square root error between the resulting counts and ideal bins.}
\item{imax}{ - For the move, merge and split operations, the index of the bin with the maximum gain.}
\item{iside}{ - For the move operation, the side of the move: 0 = left, 1 = right.}
\item{gain}{ - Error gain obtained as the result of the function call.}
}
}
\description{
\code{bins} - Cuts points in vector x into evenly distributed groups (bins).
}
\details{
\code{bins} takes 3 separate approaches to generating the cuts, picks the one
resulting in the least mean square deviation from the ideal cut -
\code{length(x) / target.bins} points in each bin - and then merges small bins
unless \code{exact.groups} is \code{TRUE}
The 3 approaches are:
\enumerate{
\item Use quantiles, and increase the number of even cuts up to max.breaks until the
number of groups reaches the desired number. See \code{\link{bins.quantiles}}.
\item Start with a single bin with all the data in it and perform bin splits until
either the desired number of bins is reached or there's no reduction in error
(the latter is ignored if \code{exact.groups} is \code{TRUE}). See \code{\link{bins.split}}.
\item Start with \code{length(table(x))} bins, each containing exactly one distinct value
and merge bins until the desired number of bins is reached. If \code{exact.groups} is
\code{FALSE}, continue merging until there's no further reduction in error.
See \code{\link{bins.merge}}.
}
For each of these approaches, apply redistribution of points among existing bins
until there's no further decrease in error. See \code{bins.move}.

The gains are computed using incremental analytical expresions derived for moving
a value from one bin to the next, splitting a bin into two or merging two bins.
}
\examples{
\dontrun{
   # Seriously skewed x:
   x <- floor(exp(rnorm(200000 * 1.3)))
   cuts <- bins(x, target.bins = 10, minpts = 2000)
   cuts$breaks <- bins.getvals(cuts)
   cuts$binct
   #   [0, 0]    [1, 1]    [2, 2]    [3, 3]    [4, 4]    [5, 5]    [6, 7]   [8, 10]
   # 129868     66611     28039     13757      7595      4550      4623      2791
   #   [11, 199]
   # 2166

   # Centered x:
   x <- rep(c(1:10,20,31:40), c(rep(1, 10), 100, rep(1,10)))
   cuts <- bins(x, target.bins = 3, minpts = 10)
   cuts$binct
   # [1, 10] [20, 20] [31, 40]
   #      10      100       10
}
}
\seealso{
\code{\link{binr}}, \code{\link{bins.greedy}}, \code{\link{bins.quantiles}} \code{\link{bins.optimize}}
}
