% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.big_SVD}
\alias{plot.big_SVD}
\title{Plot method}
\usage{
\method{plot}{big_SVD}(
  x,
  type = c("screeplot", "scores", "loadings"),
  nval = length(x$d),
  scores = c(1, 2),
  loadings = 1,
  ncol = NULL,
  coeff = 1,
  viridis = TRUE,
  cols = 2,
  ...
)
}
\arguments{
\item{x}{An object of class \code{big_SVD}.}

\item{type}{Either
\itemize{
\item "screeplot": plot of decreasing singular values (the default).
\item "scores": plot of the scores associated with 2 Principal Components.
\item "loadings": plot of loadings associated with 1 Principal Component.
}}

\item{nval}{Number of singular values to plot. Default plots all computed.}

\item{scores}{Vector of indices of the two PCs to plot. Default plots the
first two PCs. If providing more than two, it produces many plots.}

\item{loadings}{Indices of PC loadings to plot. Default plots the
first vector of loadings.}

\item{ncol}{If multiple vector of loadings are to be plotted, this defines
the number of columns of the resulting multiplot.}

\item{coeff}{Relative size of text. Default is \code{1}.}

\item{viridis}{Deprecated argument.}

\item{cols}{Deprecated. Use \code{ncol} instead.}

\item{...}{Not used.}
}
\value{
A \code{ggplot2} object. You can plot it using the \code{print} method.
You can modify it as you wish by adding layers. You might want to read
\href{https://r4ds.had.co.nz/data-visualisation.html}{this chapter}
to get more familiar with the package \strong{ggplot2}.
}
\description{
Plot method for class \code{big_SVD}.
}
\examples{
set.seed(1)

X <- big_attachExtdata()
svd <- big_SVD(X, big_scale(), k = 10)

# screeplots
plot(svd) # 3 PCs seems "significant"
plot(svd, coeff = 1.5) # larger font for papers

# scores plot
plot(svd, type = "scores") # first 2 PCs
plot(svd, type = "scores", scores = c(1, 3))
plot(svd, type = "scores", scores = 1:4, ncol = 2, coeff = 0.7)
## add color (recall that this return a `ggplot2` object)
class(obj <- plot(svd, type = "scores"))
pop <- rep(c("POP1", "POP2", "POP3"), c(143, 167, 207))
library(ggplot2)
print(obj2 <- obj + aes(color = pop) + labs(color = "Population"))
## change the place of the legend
print(obj3 <- obj2 + theme(legend.position = c(0.82, 0.17)))
## change the title and the labels of the axes
obj3 + ggtitle("Yet another title") + xlab("with an other 'x' label")

# loadings
plot(svd, type = "loadings", loadings = 2)
## all loadings
plot(svd, type = "loadings", loadings = 1:2, coeff = 0.7, ncol = 1)

# Percentage of variance explained by the PCs
# See https://github.com/privefl/bigstatsr/issues/83

# dynamic plots, require the package **plotly**
\dontrun{plotly::ggplotly(obj3)}
}
\seealso{
\link{big_SVD}, \link{big_randomSVD} and \link{asPlotlyText}.
}
