% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binom-scaling.R
\name{bed_scaleBinom}
\alias{bed_scaleBinom}
\title{Binomial(2, p) scaling}
\usage{
bed_scaleBinom(
  obj.bed,
  ind.row = rows_along(obj.bed),
  ind.col = cols_along(obj.bed),
  ncores = 1
)
}
\arguments{
\item{obj.bed}{Object of type \link{bed}, which is the mapping of some bed file.
Use \code{obj.bed <- bed(bedfile)} to get this object.}

\item{ind.row}{An optional vector of the row indices (individuals) that
are used. If not specified, all rows are used.\cr
\strong{Don't use negative indices.}}

\item{ind.col}{An optional vector of the column indices (SNPs) that are used.
If not specified, all columns are used.\cr
\strong{Don't use negative indices.}}

\item{ncores}{Number of cores used. Default doesn't use parallelism.
You may use \code{\link[bigstatsr:reexports]{bigstatsr::nb_cores()}}.}
}
\value{
A data frame with \verb{$center} and \verb{$scale}.
}
\description{
Binomial(2, p) scaling where \code{p} is estimated.
}
\details{
You will probably not use this function as is but as parameter
\code{fun.scaling} of other functions (e.g. \code{bed_autoSVD} and \code{bed_randomSVD}).
}
\examples{
bedfile <- system.file("extdata", "example-missing.bed", package = "bigsnpr")
obj.bed <- bed(bedfile)

str(bed_scaleBinom(obj.bed))

str(bed_randomSVD(obj.bed, bed_scaleBinom))

}
\references{
This scaling is widely used for SNP arrays.
Patterson N, Price AL, Reich D (2006). Population Structure and Eigenanalysis.
PLoS Genet 2(12): e190. \doi{10.1371/journal.pgen.0020190}.
}
