% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_components.R
\name{component_information}
\alias{component_information}
\alias{component_information,}
\alias{component_information.big_pls_cox,}
\alias{component_information.big_pls_cox_gd,}
\alias{select_ncomp}
\alias{component_information.big_pls_cox}
\alias{component_information.big_pls_cox_gd}
\title{Information criteria for component selection}
\usage{
component_information(object, max_comp = ncol(object$scores))

\method{component_information}{big_pls_cox}(object, max_comp = ncol(object$scores))

\method{component_information}{big_pls_cox_gd}(object, max_comp = ncol(object$scores))

select_ncomp(object, criterion = c("AIC", "BIC", "loglik"), ...)
}
\arguments{
\item{object}{A fitted object of class \code{big_pls_cox} or \code{big_pls_cox_gd}.}

\item{max_comp}{Maximum number of components to consider. Defaults to all
components stored in the model.}

\item{criterion}{Criterion to optimise: \code{"AIC"}, \code{"BIC"} or \code{"loglik"}.}

\item{...}{Passed to \code{\link[=component_information]{component_information()}}.}
}
\value{
A data frame with columns \code{ncomp}, \code{loglik}, \code{AIC}, and \code{BIC}.

A list with the table of information criteria and the recommended
number of components.
}
\description{
Computes log-likelihood, AIC and BIC values for nested models using the
latent components estimated by \code{\link[=big_pls_cox]{big_pls_cox()}} or \code{\link[=big_pls_cox_gd]{big_pls_cox_gd()}}.
}
