% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pls_fit.R
\name{bigPLSR_stream_kstats}
\alias{bigPLSR_stream_kstats}
\title{Streamed centering statistics for RKHS kernels}
\usage{
bigPLSR_stream_kstats(
  Xbm,
  kernel,
  gamma,
  degree,
  coef0,
  chunk_rows = getOption("bigPLSR.predict.chunk_rows", 8192L),
  chunk_cols = getOption("bigPLSR.predict.chunk_cols", 8192L)
)
}
\arguments{
\item{Xbm}{A \code{bigmemory::big.matrix} (or descriptor) containing the
training design matrix.}

\item{kernel}{Kernel name passed to \code{\link[stats:kernel]{stats::kernel()}} compatible helpers
(\code{"linear"}, \code{"rbf"}, \code{"poly"}, \code{"sigmoid"}).}

\item{gamma, degree, coef0}{Kernel hyper-parameters.}

\item{chunk_rows, chunk_cols}{Numbers of rows/columns to process per chunk.}
}
\value{
A list with entries \code{r} (column means) and \code{g}
(grand mean) of the kernel matrix.
}
\description{
Compute the column means and grand mean of the kernel matrix \eqn{K(X, X)}
without materialising it in memory. The input design matrix must be stored as
a \code{bigmemory::big.matrix} (or descriptor), and the kernel is evaluated by
iterating over row/column chunks.
}
