% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generic.R, R/bids.R, R/mock_bids.R
\name{mask_files}
\alias{mask_files}
\alias{mask_files.bids_project}
\alias{mask_files.mock_bids_project}
\title{Query Mask Files from a BIDS Project}
\usage{
mask_files(
  x,
  subid = ".*",
  session = ".*",
  space = ".*",
  full_path = TRUE,
  ...
)

\method{mask_files}{bids_project}(
  x,
  subid = ".*",
  session = ".*",
  space = ".*",
  full_path = TRUE,
  ...
)

\method{mask_files}{mock_bids_project}(
  x,
  subid = ".*",
  session = ".*",
  space = ".*",
  full_path = TRUE,
  ...
)
}
\arguments{
\item{x}{A \code{bids_project} or \code{mock_bids_project} object.}

\item{subid}{Regex pattern to match subject IDs (without "sub-" prefix).
Default \code{".*"} matches all subjects.}

\item{session}{Regex pattern to match session IDs (without "ses-" prefix).
Default \code{".*"} matches all sessions.}

\item{space}{Regex pattern to match coordinate space (e.g., \code{"MNI152NLin2009cAsym"}, \code{"T1w"}).
Default \code{".*"} matches all spaces.}

\item{full_path}{Logical. If \code{TRUE} (default), return absolute file paths.
If \code{FALSE}, return paths relative to project root.}

\item{...}{Additional arguments passed to \code{search_files}.}
}
\value{
Character vector of file paths matching the criteria, or \code{NULL} if
no matching files are found.
}
\description{
Retrieves paths to brain mask files from a BIDS project, optionally filtered
by subject, session, and coordinate space. Mask files are typically found in
fMRIPrep derivatives and include brain masks and tissue segmentation masks.
}
\examples{
\donttest{
# Get all mask files
tryCatch({
  ds_path <- get_example_bids_dataset("ds000001-fmriprep")
  proj <- bids_project(ds_path, fmriprep = TRUE)

  # All masks
  all_masks <- mask_files(proj)

  # Masks in MNI space
  mni_masks <- mask_files(proj, space = "MNI152")

  # Masks for specific subject
  sub01_masks <- mask_files(proj, subid = "01")

  # Clean up
  unlink(ds_path, recursive = TRUE)
}, error = function(e) {
  message("Example requires internet connection: ", e$message)
})
}
}
