% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betaDelta-beta-delta.R
\name{BetaDelta}
\alias{BetaDelta}
\title{Estimate Standardized Regression Coefficients
and the Corresponding Sampling Covariance Matrix}
\usage{
BetaDelta(object, type = "mvn", alpha = c(0.05, 0.01, 0.001))
}
\arguments{
\item{object}{Object of class \code{lm}.}

\item{type}{Character string.
If \code{type = "mvn"},
use the multivariate normal-theory approach.
If \code{type = "adf"},
use the asymptotic distribution-free approach.}

\item{alpha}{Numeric vector.
Significance level \eqn{\alpha}.}
}
\value{
Returns an object
of class \code{betadelta} which is a list with the following elements:
\describe{
\item{call}{Function call.}
\item{args}{Function arguments.}
\item{lm_process}{Processed \code{lm} object.}
\item{gamma}{Asymptotic covariance matrix
of the sample covariance matrix.}
\item{acov}{Asymptotic covariance matrix
of the standardized slopes.}
\item{vcov}{Sampling covariance matrix
of the standardized slopes.}
\item{est}{Vector of standardized slopes.}
}
}
\description{
Estimate Standardized Regression Coefficients
and the Corresponding Sampling Covariance Matrix
}
\examples{
object <- lm(QUALITY ~ NARTIC + PCTGRT + PCTSUPP, data = nas1982)
std <- BetaDelta(object)
# Methods -------------------------------------------------------
print(std)
summary(std)
coef(std)
vcov(std)
confint(std, level = 0.95)

}
\references{
Jones, J. A., & Waller, N. G. (2015).
The normal-theory and asymptotic distribution-free (ADF) covariance matrix
of standardized regression coefficients:
Theoretical extensions and finite sample behavior.
\emph{Psychometrika}, \emph{80}(2), 365–378.
\doi{10.1007/s11336-013-9380-y}

Pesigan, I. J. A., Sun, R. W., & Cheung, S. F. (2023).
betaDelta and betaSandwich:
Confidence intervals for standardized regression coefficients in R.
\emph{Multivariate Behavioral Research}.
\doi{10.1080/00273171.2023.2201277}

Yuan, K.-H., & Chan, W. (2011).
Biases and standard errors of standardized regression coefficients.
\emph{Psychometrika}, \emph{76}(4), 670–690.
\doi{10.1007/s11336-011-9224-6}
}
\seealso{
Other Beta Delta Functions: 
\code{\link{DiffBetaDelta}()}
}
\author{
Ivan Jacob Agaloos Pesigan
}
\concept{Beta Delta Functions}
\keyword{betaDelta}
\keyword{std}
