% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bdc_scientificName_empty.R
\name{bdc_scientificName_empty}
\alias{bdc_scientificName_empty}
\title{Identify records with empty scientific names}
\usage{
bdc_scientificName_empty(data, sci_names = "scientificName")
}
\arguments{
\item{data}{data.frame. Containing the species scientific names.}

\item{sci_names}{character string. The column name with the species
scientific name. Default = "scientificName".}
}
\value{
A data.frame containing the column ".scientificName_empty". Compliant
(TRUE) if 'sci_names' is not empty; otherwise "FALSE".
}
\description{
Flags records with empty or not interpretable scientific names.
}
\details{
This test identifies records missing scientific names (i.e., empty
or not applicable \link{NA} names)
}
\examples{
x <- data.frame(scientificName = c("Ocotea odorifera", NA, "Panthera onca", ""))
bdc_scientificName_empty(data = x, sci_names = "scientificName")

}
\seealso{
Other prefilter: 
\code{\link{bdc_basisOfRecords_notStandard}()},
\code{\link{bdc_coordinates_country_inconsistent}()},
\code{\link{bdc_coordinates_empty}()},
\code{\link{bdc_coordinates_from_locality}()},
\code{\link{bdc_coordinates_outOfRange}()},
\code{\link{bdc_coordinates_transposed}()},
\code{\link{bdc_country_standardized}()}
}
\concept{prefilter}
