% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.summary.clogit_bclogit.R
\name{print.summary.clogit_bclogit}
\alias{print.summary.clogit_bclogit}
\title{Print summary of a clogit_bclogit model}
\usage{
\method{print}{summary.clogit_bclogit}(x, digits = max(3, getOption("digits") - 3), ...)
}
\arguments{
\item{x}{A \code{summary.clogit_bclogit} object.}

\item{digits}{Number of significant digits to print.}

\item{...}{Additional arguments.}
}
\value{
Invisibly returns \code{x}.
}
\description{
Print summary of a clogit_bclogit model
}
\examples{
n <- 200
dat <- data.frame(
  y = rbinom(n, 1, 0.5), x1 = rnorm(n),
  treatment = rep(c(0, 1), n / 2),
  strata = rep(1:(n / 2), each = 2)
)
fit <- clogit(y ~ x1, data = dat, treatment = treatment, strata = strata)
print(summary(fit))
}
