% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.glm_b.R
\name{predict.glm_b}
\alias{predict.glm_b}
\title{Predict method for glm_b model fits}
\usage{
\method{predict}{glm_b}(
  object,
  newdata,
  trials,
  CI_level = 0.95,
  PI_level = 0.95,
  seed = 1,
  n_draws = 5000,
  ...
)
}
\arguments{
\item{object}{Object of class glm_b}

\item{newdata}{An optional data.frame in which to look for variables with which
to predict.}

\item{trials}{Integer vector giving the number of trials for each
observation if family = binomial().}

\item{CI_level}{Posterior probability covered by credible interval}

\item{PI_level}{Posterior probability covered by prediction interval}

\item{seed}{integer.  Always set your seed!!!}

\item{n_draws}{integer.  Number of posterior draws used for prediction}

\item{...}{optional arguments.}
}
\value{
tibble with estimate (posterior mean), prediction intervals, and credible intervals
for the mean.
}
\description{
Predict method for glm_b model fits
}
\examples{
\donttest{
set.seed(2025)
N = 500
test_data =
  data.frame(x1 = rnorm(N),
             x2 = rnorm(N),
             x3 = letters[1:5],
             time = rexp(N))
test_data$outcome =
  rnbinom(N,
          mu = exp(-2 + test_data$x1 + 2 * (test_data$x3 \%in\% c("d","e"))) * test_data$time,
          size = 0.7)

# Fit using variational Bayes (default)
fit_vb1 <-
  glm_b(outcome ~ x1 + x2 + x3 + offset(log(time)),
        data = test_data,
        family = negbinom(),
        seed = 2025)
# Predict
predict(fit_vb1)
}


}
