% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostics.R
\name{validate_ou_fit}
\alias{validate_ou_fit}
\title{Validate OU model fit}
\usage{
validate_ou_fit(fit_res, verbose = TRUE)
}
\arguments{
\item{fit_res}{List returned by \code{\link{fit_ou_nonlinear_tmg}}}

\item{verbose}{Logical. Print detailed output. Default TRUE.}
}
\value{
Invisibly returns the diagnostics list
}
\description{
Prints diagnostic summaries and hypothesis tests for a fitted model.
}
\examples{
\donttest{
# Create a dummy results list that mimics the output of fit_ou_nonlinear_tmg
dummy_results <- list(
  diagnostics = list(
    rhat = c(alpha = 1.01, beta = 1.00),
    ess = c(alpha = 400, beta = 350),
    loo = list(estimates = matrix(c(1, 0.1), ncol=2, 
               dimnames=list("elpd_loo", c("Estimate", "SE")))),
    oos = list(h1 = list(RMSE = 0.5))
  ),
  factor_ou = list(beta1 = 0.3),
  nonlinear = list(a3 = -0.5),
  sv = list(rho_s = 0.2)
)

# Run validation on the dummy object
validate_ou_fit(dummy_results)
}

}
