% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_evaluation.R
\name{get_evaluation.app}
\alias{get_evaluation.app}
\title{Evaluate a Basket Trial with the Adaptive Power Prior Design
for sequential clinical trials}
\usage{
\method{get_evaluation}{app}(design, n, r, lambda, level = 0.95, ...)
}
\arguments{
\item{design}{An object of class \code{app}.}

\item{n}{The sample sizes of the baskets. A vector must be used for varying sample sizes.}

\item{r}{Vector of responses.}

\item{lambda}{The posterior probability threshold.}

\item{level}{Level of the credibility intervals.}

\item{...}{Further arguments.}
}
\value{
A list containing the point estimates of the basket-specific response rates and the
posterior probabilities that the estimated response rates are above a specified threshold p0.
}
\description{
Evaluate a Basket Trial with the Adaptive Power Prior Design
for sequential clinical trials
}
\examples{
design <- setup_app(k = 3, p0 = 0.2)

# Equal sample sizes
get_evaluation(design = design, n = 20, r = c(10, 15, 5),
 lambda = 0.95, iter = 100)

# Unequal sample sizes
get_evaluation(design = design, n = c(15, 20, 25), r = c(10, 15, 17),
 lambda = 0.95, iter = 100)

}
