% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/baselinenowcast_df-class.R
\name{baselinenowcast_df-class}
\alias{baselinenowcast_df-class}
\alias{baselinenowcast_df}
\title{Nowcast Data.frame Object}
\value{
A \code{baselinenowcast_df} object. This is a data.frame subclass
containing nowcast results. See the Structure section for details on
the required columns.
}
\description{
A \code{baselinenowcast_df} object which contains point or probabilistic nowcasts
alongside reference dates and any additional metadata, in tidy data format.
Nowcasts are presented aggregated across delays, by reference date.
}
\section{Structure}{

A \code{baselinenowcast_df} is a data.frame with the following columns:
\describe{
\item{reference_date}{Dates corresponding to the reference times of the
nowcast.}
\item{pred_count}{Numeric indicating the estimated total counts aggregated
across delays at each reference date.}
\item{draw}{Integer indexing the sample from the probabilistic nowcast
distribution. If \code{output_type = "point"}, this will be set to 1.}
\item{output_type}{Character string indicating whether the \code{pred_count}
represents a probabilistic draw from the observation model indicated by
\code{"samples"} or whether the \code{pred_count} is a point estimate indicated by
\code{"point"}.}
}
See the corresponding \link{reporting_triangle} and
\code{\link[=baselinenowcast]{baselinenowcast()}} function
for more details on the required inputs to generate the object.
}

\seealso{
Main nowcasting interface functions
\code{\link{assert_baselinenowcast_df}()},
\code{\link{baselinenowcast}()},
\code{\link{baselinenowcast.data.frame}()},
\code{\link{baselinenowcast.reporting_triangle}()},
\code{\link{new_baselinenowcast_df}()}
}
\concept{baselinenowcast_df}
