% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim2Animation.R
\name{sim2Animation}
\alias{sim2Animation}
\title{sim2Animation: Animate BAM simulation object.}
\usage{
sim2Animation(
  sdm_simul,
  which_steps,
  fmt = "GIF",
  filename,
  png_keyword = NULL,
  extra_legend = NULL,
  bg_color = "#F6F2E5",
  suit_color = "#0076BE",
  occupied_color = "#03C33F",
  gif_vel = 0.8,
  ani.width = 1200,
  ani.height = 1200,
  ani.res = 300
)
}
\arguments{
\item{sdm_simul}{A bam object. See \code{\link[bamm]{sdm_sim}}}

\item{which_steps}{A numeric vector indicating the simulation steps that
are going to be converted into raster layers.}

\item{fmt}{Animation format. Possible values are GIF and HTML}

\item{filename}{File name.}

\item{png_keyword}{A keyword name for the png images generated by the
function}

\item{extra_legend}{A legend  to add to the animation.}

\item{bg_color}{Color for unsuitable pixels. Default "#F6F2E5".}

\item{suit_color}{Color for suitable pixels. Default "#0076BE".}

\item{occupied_color}{Color for occupied pixels. Default "#03C33F".}

\item{gif_vel}{A value that regulates the velocity of frame transitions.
The bigger it is the transition will be slower
default 0.8}

\item{ani.width}{Animation width unit in px}

\item{ani.height}{Animation height unit in px}

\item{ani.res}{Animation resolution unit in px}
}
\value{
A RasterStack of species' distribution at each simulation step
}
\description{
Animates BAM simulation object.
}
\details{
The animation can be saved in a GIF or HTML format. Note that
the generation of the GIF can be time consuming for large simulation
(simulations with more than 60 time steps).
}
\examples{
model_path <- system.file("extdata/Lepus_californicus_cont.tif",
                          package = "bamm")
model <- raster::raster(model_path)
sparse_mod <- bamm::model2sparse(model,0.1)
adj_mod <- bamm::adj_mat(sparse_mod,ngbs=2)
occs_lep_cal <- data.frame(longitude = c(-115.10417,
                                         -104.90417),
                           latitude = c(29.61846,
                                        29.81846))
occs_sparse <- bamm::occs2sparse(modelsparse = sparse_mod,
                                occs = occs_lep_cal)
sdm_lep_cal <- bamm::sdm_sim(set_A = sparse_mod,
                            set_M = adj_mod,
                            initial_points = occs_sparse,
                            nsteps = 50)
\donttest{
if(requireNamespace("animation")){
ani_name <- tempfile(pattern = "simulation_",fileext = ".html")
#sdm_lep_cal_st <- bamm::sim2Animation(sdm_simul = sdm_lep_cal,
#                                      which_steps = seq(1,50,by=1),
#                                      fmt = "HTML",ani.width = 1200,
#                                      ani.height = 1200,
#                                      filename = ani_name)
}
}
}
\author{
Luis Osorio-Olvera & Jorge Soberón
}
