% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Encoder_Decoder_Info.R
\name{encoder_decoder_information}
\alias{encoder_decoder_information}
\title{Specifying Encoder and Decoder Architectures for \code{VAE_train()}}
\description{
Specifying Encoder and Decoder Architectures for \code{VAE_train()}
}
\section{Encoder and Decoder configuration}{

The arguments \code{encoder_info} and \code{decoder_info} define the architecture of
the encoder and decoder networks used in \code{VAE_train()}. Each is a list in
which every element describes one layer in sequence.

AutoTab currently supports two layer types: \code{"dense"} and \code{"dropout"}.

\strong{Dense layers}

When \code{input1 = "dense"}, the layer specification takes the form:

\itemize{
\item \code{input2}: \emph{Numeric.} Number of units (nodes).
\item \code{input3}: \emph{Character.} Activation function
(any TensorFlow/Keras activation name).
\item \code{input4}: \emph{Integer (0/1).} L2 regularization flag. Default: \code{0}.
\item \code{input5}: \emph{Numeric.} L2 regularization strength (\code{lambda}). Default: \code{1e-4}.
\item \code{input6}: \emph{Logical.} Apply batch normalization. Default: \code{FALSE}.
\item \code{input7}: \emph{Numeric.} Batch normalization momentum. Default: \code{0.99}.
\item \code{input8}: \emph{Logical.} Whether batch normalization scale and center
parameters are trainable. Default: \code{TRUE}.
}

\strong{Dropout layers}

When \code{input1 = "dropout"}, the layer specification is:

\itemize{
\item \code{input2}: \emph{Numeric.} Dropout rate.
}

Together, these lists fully specify the encoder and decoder architectures
used during VAE training.
}

\seealso{
\code{\link[=VAE_train]{VAE_train()}}
}
