% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constants.R
\docType{data}
\name{automerge-constants}
\alias{automerge-constants}
\alias{AM_ROOT}
\alias{AM_OBJ_TYPE_LIST}
\alias{AM_OBJ_TYPE_MAP}
\alias{AM_OBJ_TYPE_TEXT}
\alias{AM_MARK_EXPAND_NONE}
\alias{AM_MARK_EXPAND_BEFORE}
\alias{AM_MARK_EXPAND_AFTER}
\alias{AM_MARK_EXPAND_BOTH}
\title{Automerge Constants}
\format{
An object of class \code{NULL} of length 0.

An object of class \code{am_obj_type} of length 1.

An object of class \code{am_obj_type} of length 1.

An object of class \code{am_obj_type} of length 1.

An object of class \code{character} of length 1.

An object of class \code{character} of length 1.

An object of class \code{character} of length 1.

An object of class \code{character} of length 1.
}
\usage{
AM_ROOT

AM_OBJ_TYPE_LIST

AM_OBJ_TYPE_MAP

AM_OBJ_TYPE_TEXT

AM_MARK_EXPAND_NONE

AM_MARK_EXPAND_BEFORE

AM_MARK_EXPAND_AFTER

AM_MARK_EXPAND_BOTH
}
\description{
Constants used throughout the automerge package for object types,
root references, and mark expansion modes.
}
\section{Root Object}{

\describe{
\item{AM_ROOT}{Reference to the root object of an Automerge document.
Use this as the \code{obj} parameter when operating on the top-level
map. Value is \code{NULL} which maps to the C API's AM_ROOT.}
}
}

\section{Object Types}{

String constants for creating Automerge objects:
\describe{
\item{AM_OBJ_TYPE_LIST}{Create a list (array) object. Lists are ordered
sequences accessed by numeric index (1-based in R).}
\item{AM_OBJ_TYPE_MAP}{Create a map (object) object. Maps are unordered
key-value collections accessed by string keys.}
\item{AM_OBJ_TYPE_TEXT}{Create a text object for collaborative editing.
Text objects support character-level CRDT operations, cursor stability,
and formatting marks. Use text objects for collaborative document editing
rather than regular strings (which use last-write-wins semantics).}
}
}

\section{Mark Expansion Modes}{

Constants for controlling how text marks expand when text is inserted
at their boundaries (used with \code{am_mark}):
\describe{
\item{AM_MARK_EXPAND_NONE}{Mark does not expand when text is inserted
at either boundary.}
\item{AM_MARK_EXPAND_BEFORE}{Mark expands to include text inserted
immediately before its start position.}
\item{AM_MARK_EXPAND_AFTER}{Mark expands to include text inserted
immediately after its end position.}
\item{AM_MARK_EXPAND_BOTH}{Mark expands to include text inserted at
either boundary (before start or after end).}
}
}

\keyword{datasets}
