% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/document.R
\name{am_set_actor}
\alias{am_set_actor}
\title{Set the actor ID of a document}
\usage{
am_set_actor(doc, actor_id)
}
\arguments{
\item{doc}{An Automerge document}

\item{actor_id}{The new actor ID. Can be:
\itemize{
\item \code{NULL} - Generate new random actor ID
\item Character string - Hex-encoded actor ID
\item Raw vector - Binary actor ID bytes
}}
}
\value{
The document \code{doc} (invisibly)
}
\description{
Sets the actor ID for an Automerge document. This should typically
be done before making any changes. Changing the actor ID mid-session
is not recommended as it can complicate change attribution.
}
\examples{
doc <- am_create()

# Set custom actor ID from hex string
am_set_actor(doc, "0123456789abcdef0123456789abcdef")

# Generate new random actor ID
am_set_actor(doc, NULL)
}
