% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strj-tokenize.R
\name{strj_tokenize}
\alias{strj_tokenize}
\alias{strj_segment}
\alias{strj_tinyseg}
\title{Tokenize Japanese text}
\usage{
strj_tokenize(
  text,
  format = c("list", "data.frame"),
  engine = c("stringi", "budoux", "tinyseg"),
  split = FALSE,
  ...
)

strj_segment(text, format = c("list", "data.frame"), split = FALSE)

strj_tinyseg(text, format = c("list", "data.frame"), split = FALSE)
}
\arguments{
\item{text}{A character vector of Japanese text to tokenize.}

\item{format}{A string specifying the output format.}

\item{engine}{A string specifying the tokenization engine to use.}

\item{split}{A logical value indicating whether \code{text} should be split
into individual sentences before tokenization.}

\item{...}{Additional arguments passed to the underlying engine.}
}
\value{
If \code{format = "list"}, a named list of character vectors, one per input
element.
If \code{format = "data.frame"}, a data frame containing document identifiers
and tokenized text.
}
\description{
Tokenizes Japanese character strings using a selectable segmentation
engine and returns the result as a list or a data frame.

This function provides a unified interface to multiple Japanese text
segmentation backends. External command-based engines were removed in
v0.6.0, and all tokenization is performed using in-process
implementations.

\code{strj_segment()} and \code{strj_tinyseg()} are aliases for \code{strj_tokenize()}
with the \code{"budoux"} and \code{"tinyseg"} engines, respectively.
}
\details{
The following engines are supported:
\itemize{
\item \code{"stringi"}: Uses ICU-based boundary analysis via stringi.
\item \code{"budoux"}: Uses a rule-based Japanese phrase segmentation algorithm.
\item \code{"tinyseg"}: Uses a TinySegmenter-compatible statistical model.
}

The legacy \code{"mecab"} and \code{"sudachipy"} engines were removed in v0.6.0.
}
\examples{
strj_tokenize(
  paste0(
    "\u3042\u306e\u30a4\u30fc\u30cf\u30c8",
    "\u30fc\u30f4\u30a9\u306e\u3059\u304d",
    "\u3068\u304a\u3063\u305f\u98a8"
  )
)
strj_tokenize(
  paste0(
    "\u3042\u306e\u30a4\u30fc\u30cf\u30c8",
    "\u30fc\u30f4\u30a9\u306e\u3059\u304d",
    "\u3068\u304a\u3063\u305f\u98a8"
  ),
  format = "data.frame"
)
}
