\name{MEI}
\alias{MEI}
\docType{data}
\title{
Multivariate El Nino/Southern Oscillation Index (version 1)
}
\description{
Bimonthly MEI values, starting with Dec1949/Jan1950 through Oct/Nov2019.  
All values are normalized for each bimonthly season so that the 44 values from 1950 to 1993 
have an average of zero and a standard deviation of 1.  Larger values correspond to warmer
temperatures (unlike \code{soi} and \code{ENSO}).
}
\format{
  The format is:
 Time-Series [1:827] from 1950 to 2019: -1.03 -1.13 -1.28 -1.07 -1.43 ...
}
\details{For full details, see \kbd{https://psl.noaa.gov/enso/mei.old/mei.html}.
Multivariate ENSO Index (MEI) is a combined score on the six main observed variables over the tropical Pacific. These six variables are: sea-level pressure (P), zonal (U) and meridional (V) components of the surface wind, sea surface temperature (S), surface air temperature (A), and total cloudiness fraction of the sky (C). These observations have been collected and published in ICOADS for many years. The MEI is computed separately for each of twelve sliding bi-monthly seasons (Dec/Jan, Jan/Feb,..., Nov/Dec). After spatially filtering the individual fields into clusters, the MEI is calculated as the first unrotated Principal Component (PC) of all six observed fields combined. This is accomplished by normalizing the total variance of each field first, and then performing the extraction of the first PC on the co-variance matrix of the combined fields. In order to keep the MEI comparable, all seasonal values are standardized with respect to each season and to the 1950-93 reference period.

Weak El Nino: MEI is between +0.5 and +1.0.\cr
Moderate El Nino: MEI is between +1.0 and +1.5.\cr
Strong El Nino: MEI is between +1.5 and +2.0.\cr
Very Strong El Nino: MEI is at or above +2.0.\cr
Values below the negative of these indicate La Nina conditions. 
}
\source{
\kbd{https://psl.noaa.gov/enso/mei.old/table.html}
}
\references{You can find demonstrations of  astsa capabilities at  
\href{https://github.com/nickpoison/astsa/blob/master/fun_with_astsa/fun_with_astsa.md}{FUN WITH ASTSA}.

The most recent version of the package can be found  at \url{https://github.com/nickpoison/astsa/}.

In addition, the News and ChangeLog files are at  \url{https://github.com/nickpoison/astsa/blob/master/NEWS.md}.

The webpages for the texts and some help on using R for time series analysis can be found at
 \url{https://nickpoison.github.io/}.  
}
\seealso{\code{\link{soi}, \link{ENSO}, \link{MEI2}}
}
\examples{
tsplot(cbind(MEI, MEI2), spag=TRUE, col=2*2:1, addLegend=TRUE, nym=2, gg=TRUE)


tspairs(ts.intersect(MEI, MEI2), location='top')

}
\keyword{datasets}
