\name{grey_cloud_2015}
\docType{data}
\alias{grey_cloud_2015}
\title{Life History Data on Chamaecrista fasiculata}
\description{
  Data on life history traits for the partridge pea
  \emph{Chamaecrista fasiculata}
}
\usage{data(grey_cloud_2015)}
\format{
  Loads 3 R objects.
  \describe{
    \item{redata}{A data frame with records for 3658 plants.
    Data are already in \dQuote{long} format; no need to reshape.
    Variables contained include
    \describe{
      \item{resp}{Response vector.}
      \item{varb}{Categorical.  Gives node of graphical model corresponding
      to each component of \code{resp}.  See details below.}
      \item{root}{All ones.  Root variables for graphical model.}
      \item{fit}{Bernoulli.  Indicates terminal node (fitness) of the graph.
        Same as \code{as.numeric(varb == "totalseeds")}.}
      \item{id}{Categorical.  Indicates individual plants.}
      \item{block}{Categorical.  Indicates block in experimental design.}
      \item{paternalID}{Categorical.  Indicates father.}
      \item{maternalID}{Categorical.  Indicates mother.}
    }
    }
  }
}
\details{
The levels of \code{varb} indicate nodes of the graphical model to which
the corresponding elements of the response vector \code{resp} belong.
This is the typical \dQuote{long} format produced by the R \code{reshape}
function.  For each individual, there are several response variables.
All response variables are combined in one vector \code{resp}.
The variable \code{varb} indicates which \dQuote{original} variable
the number was for.  The variable \code{id} indicates which individual
the number was for.  The levels of \code{varb}, which are the names
of the \dQuote{original} variables are the following.
\describe{
  \item{Germ}{Bernoulli, one indicates individual germinated.}
  \item{flw}{Conditionally Bernoulli given \code{germ}, one indicates
    individual flowered.}
  \item{total.pods}{Conditionally Poisson given \code{flw}, counts number
    of seed pods produced.}     
  \item{total.pods.collected}{Conditionally Bernoulli given \code{total.pods},
    size of the subsample of the \code{total.pods} counted by the scientists.}
  \item{totalseeds}{Conditionally Poisson given \code{total.pods.collected},
    total number of seeds found in the subsample of pods.}
}
}
\references{
These data were published in the following.

Kulbaba, M. W., Sheth, S. N., Pain, R. E., Eckhart, V. M. and Shaw, R. G.
(2019)
Additive genetic variance for lifetime fitness and the capacity for
adaptation in an annual plant
\emph{Evolution}, \bold{73}, 1746--1758.
\doi{10.1111/evo.13830}.

Geyer, C. J., Kulbaba, M. W., Sheth, S. N., Pain, R. E., Eckhart, V. M.
and Shaw, R. G. (2022)
Correction for Kulbaba et al. (2019).
\emph{Evolution}, \bold{76}, 3074.
\doi{10.1111/evo.14607}.
Supplementary material, version 2.0.1.  \doi{10.5281/zenodo.7013098}.

Shaw, R. G., Geyer, C. J., Kulbaba, M. W., Sheth, S. N., Eckhart, V. M. and
    Pain, R. E. (in preparation).
Realization of ongoing evolutionary adaptation in the field.
Supplementary material (all of the data analysis)
\doi{10.5281/zenodo.17093288}.
}
\examples{
data(grey_cloud_2015)
\dontrun{
# takes too long for CRAN
modmat.sire <- model.matrix(~ 0 + fit:paternalID, redata)
modmat.dam <- model.matrix(~ 0 + fit:maternalID, redata)
modmat.siredam <- cbind(modmat.sire, modmat.dam)
rout <- reaster(resp ~ fit + varb,
    list(parental = ~ 0 + modmat.siredam, block = ~ 0 + fit:block),
    pred, fam, varb, id, root, data = redata)
}
}
\keyword{datasets}

