% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert_functions.R
\name{assert_function_expects}
\alias{assert_function_expects}
\title{Assert function expects specific parameter names}
\usage{
assert_function_expects(
  x,
  required,
  msg = NULL,
  call = rlang::caller_env(),
  arg_name = NULL
)
}
\arguments{
\item{x}{a function to check for required parameter names}

\item{required}{a character vector of parameter names that must appear in
the function signature (order does not matter)}

\item{msg}{The error message thrown if the assertion fails (string)}

\item{call}{Only relevant when pooling assertions into multi-assertion helper functions. See \link[cli]{cli_abort} for details.}

\item{arg_name}{Advanced use only. Name of the argument passed (default: NULL, will automatically extract arg_name).}
}
\value{
invisible(TRUE) if function \code{x} declares all required parameters,
otherwise aborts with the error message specified by \code{msg}
}
\description{
Assert that a function signature includes required set of parameter names in its
formal argument list, regardless of whether those parameters have default
values. The \code{...} argument is ignored.
}
\examples{
my_fun <- function(x, y = 1, ...) x + y
assert_function_expects(my_fun, c("x", "y"))

try({
  assert_function_expects(my_fun, c("x", "z"))
})

}
