% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert_numerical.R
\name{assert_finite}
\alias{assert_finite}
\title{Assert that a value is finite}
\usage{
assert_finite(x, msg = NULL, call = rlang::caller_env(), arg_name = NULL)
}
\arguments{
\item{x}{An object}

\item{msg}{The error message thrown if the assertion fails (string)}

\item{call}{Only relevant when pooling assertions into multi-assertion helper functions. See \link[cli]{cli_abort} for details.}

\item{arg_name}{Advanced use only. Name of the argument passed (default: NULL, will automatically extract arg_name).}
}
\value{
invisible(TRUE) if \code{x} is finite, otherwise aborts with the error message specified by \code{msg}
}
\description{
Check that a single numeric value is finite (not \code{NA}, \code{NaN}, \code{Inf}, or \code{-Inf}).
For vectorized version see \code{\link[=assert_all_finite]{assert_all_finite()}}.
}
\examples{
try({
assert_finite(1) # Passes
assert_finite(Inf) # Throws error
})

}
\concept{assert_numerical}
