% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nutrient_functions.R
\name{nutrient_response}
\alias{nutrient_response}
\title{Nutrient Response Curve Analysis}
\usage{
nutrient_response(
  dose,
  yield,
  model = "quadratic",
  price_output = 50,
  price_nutrient = 15,
  verbose = TRUE
)
}
\arguments{
\item{dose}{Numeric vector of nutrient doses (kg/ha)}

\item{yield}{Numeric vector of corresponding yields (kg/ha)}

\item{model}{Model type: "quadratic", "linear_plateau", or "mitscherlich"}

\item{price_output}{Price of output (Rs/kg)}

\item{price_nutrient}{Price of nutrient (Rs/kg)}

\item{verbose}{Logical. If TRUE (default), prints formatted output to console.}
}
\value{
List with model parameters and economic optimum
}
\description{
Fits nutrient response curves using quadratic, linear-plateau, or 
Mitscherlich models to determine economic optimum dose.
}
\examples{
dose <- c(0, 20, 40, 60, 80, 100)
yield <- c(1100, 1350, 1520, 1610, 1650, 1660)
nutrient_response(dose, yield, model = "quadratic", 
                  price_output = 60, price_nutrient = 15)

}
\author{
Lalit Kumar Rolaniya, ICAR-IIPR, Bikaner
}
