% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/design_additional.R
\name{anova_augmented}
\alias{anova_augmented}
\title{Augmented Block Design ANOVA}
\usage{
anova_augmented(data, response, genotype, block, check_names, verbose = TRUE)
}
\arguments{
\item{data}{Data frame containing the data}

\item{response}{Name of response variable}

\item{genotype}{Name of genotype/entry column}

\item{block}{Name of block column}

\item{check_names}{Vector of check variety names}

\item{verbose}{Logical. If TRUE (default), prints formatted output to console.}
}
\value{
List containing ANOVA results and adjusted means
}
\description{
Performs ANOVA for Augmented Randomized Block Design where checks are
replicated and test entries appear once.
}
\examples{
data <- data.frame(
  block = rep(1:5, each = 7),
  genotype = c(rep(c("C1","C2","C3"), 5), paste0("T", 1:20)),
  yield = rnorm(35, 1200, 150)
)
# Note: This is simplified example

}
\author{
Lalit Kumar Rolaniya, Ram Lal Jat, Monika Punia, Raja Ram Choudhary
}
