% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare.R
\name{anki_compare_periods}
\alias{anki_compare_periods}
\title{Compare two time periods}
\usage{
anki_compare_periods(
  path = NULL,
  profile = NULL,
  period1 = NULL,
  period2 = NULL,
  period_names = c("Period 1", "Period 2")
)
}
\arguments{
\item{path}{Path to collection.anki2 (auto-detected if NULL)}

\item{profile}{Profile name (first profile if NULL)}

\item{period1}{First period as c(start_date, end_date)}

\item{period2}{Second period as c(start_date, end_date)}

\item{period_names}{Names for the periods (default: "Period 1", "Period 2")}
}
\value{
A tibble comparing the two periods
}
\description{
Compare study statistics between two time periods.
}
\examples{
\dontrun{
# Compare this month vs last month
anki_compare_periods(
  period1 = c("2024-01-01", "2024-01-31"),
  period2 = c("2024-02-01", "2024-02-29"),
  period_names = c("January", "February")
)
}
}
