% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/proxy.R
\docType{methods}
\name{proxy_ensemble}
\alias{proxy_ensemble}
\alias{proxy_ensemble-method}
\alias{proxy_ensemble,numeric-method}
\title{Layer-Counted Proxy Records Uncertainties}
\usage{
proxy_ensemble(positions, ...)

\S4method{proxy_ensemble}{numeric}(
  positions,
  proxy_values,
  proxy_errors,
  proxy_step,
  time_values,
  time_errors,
  calendar,
  from = NULL,
  to = NULL,
  by = NULL,
  n = 30,
  progress = getOption("ananke.progress"),
  verbose = getOption("ananke.verbose")
)
}
\arguments{
\item{positions}{A positive \code{\link{numeric}} vector giving the positions (e.g.
depths) at which proxy values and calendar ages were measured. In the case
of layers of non-zero thickness, this should be the middle value of the
slice. It must be in decreasing order (i.e. in chronological order).}

\item{...}{Currently not used.}

\item{proxy_values}{A \code{\link{numeric}} vector giving the proxy values.}

\item{proxy_errors}{A \code{\link{numeric}} vector giving the proxy uncertainties.}

\item{proxy_step}{A length-one \code{\link{numeric}} vector specifying the step size
(in units of \code{proxy_values}) at which proxy records densities are to be
estimated.}

\item{time_values}{A \code{\link{numeric}} vector giving the calendar ages (in years).}

\item{time_errors}{A \code{\link{numeric}} vector giving the calendar age uncertainties
(in years).}

\item{calendar}{An \code{\link[aion:TimeScale-class]{aion::TimeScale}} object specifying the calendar
of \code{time} (see \code{\link[aion:calendar]{aion::calendar()}}).}

\item{from}{A length-one \code{\link{numeric}} vector specifying the starting value of
the temporal sequence at which densities are to be estimated (in years).}

\item{to}{A length-one \code{\link{numeric}} vector specifying the end value of the
temporal sequence at which densities are to be estimated (in cal BP years).}

\item{by}{A length-one \code{\link{numeric}} vector specifying the increment of
the temporal sequence at which densities are to be estimated (in years).}

\item{n}{An \code{\link{integer}} specifying the number of item to choose randomly.}

\item{progress}{A \code{\link{logical}} scalar: should a progress bar be displayed?}

\item{verbose}{A \code{\link{logical}} scalar: should extra information be reported?}
}
\value{
A \code{\linkS4class{ProxyRecord}} object.
}
\description{
Represents layer-counted proxy records as sequences of probability
distributions on absolute, error-free time axes.
}
\note{
This function is currently \emph{experimental}.
}
\examples{
\donttest{
## Get NGRIP records
data("ngrip2010", package = "folio")
ngrip2010 <- subset(ngrip2010, !is.na(MCE))
ngrip2010 <- ngrip2010[nrow(ngrip2010):1, ] # Sort in chronological order

## Replicate fig. 3d from Boers et al. (2017)
## /!\ This may take a while... /!\
ngrip_record <- proxy_ensemble(
  positions = ngrip2010$depth,
  proxy_values = ngrip2010$delta,
  proxy_errors = 0.01,
  proxy_step = 0.01,
  time_values = ngrip2010$age,
  time_errors = ngrip2010$MCE,
  calendar = b2k(), # /!\
  by = 20,
  n = 30
)

plot(ngrip_record)
}
}
\references{
Boers, N., Goswami, B. & Ghil, M. (2017). A Complete Representation of
Uncertainties in Layer-Counted Paleoclimatic Archives. \emph{Climate of the
Past}, 13(9): 1169-1180. \doi{10.5194/cp-13-1169-2017}.
}
\seealso{
Other proxy tools: 
\code{\link{proxy_plot}}
}
\author{
N. Frerebeau
}
\concept{proxy tools}
