% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/pb_age.R
\docType{methods}
\name{pb_age}
\alias{pb_age}
\alias{pb_age,numeric,numeric,numeric-method}
\alias{pb_age,list,missing,missing-method}
\title{Geological Model Age from Lead Isotope Analysis}
\usage{
pb_age(x, y, z, ...)

\S4method{pb_age}{numeric,numeric,numeric}(
  x,
  y,
  z,
  t0 = 3.8,
  x_star = 18.75,
  y_star = 15.63,
  z_star = 38.86,
  mu = 9.66,
  kappa = 3.9,
  th232 = 0.049475,
  u238 = 0.155125,
  u235 = 0.98485,
  u238_235 = 137.79,
  tolerance = sqrt(.Machine$double.eps),
  stop = 100
)

\S4method{pb_age}{list,missing,missing}(
  x,
  t0 = 3.8,
  x_star = 18.75,
  y_star = 15.63,
  z_star = 38.86,
  mu = 9.66,
  kappa = 3.9,
  th232 = 0.049475,
  u238 = 0.155125,
  u235 = 0.98485,
  u238_235 = 137.79,
  tolerance = sqrt(.Machine$double.eps),
  stop = 100
)
}
\arguments{
\item{x}{A \code{\link{numeric}} vector of 206Pb/204Pb ratios. If \code{y} and \code{z} are
missing, must be a \code{\link{list}} (or a \code{\link{data.frame}}) with \code{numeric} components
(columns) \code{x}, \code{y} and \code{z}.}

\item{y}{A \code{\link{numeric}} vector of 207Pb/204Pb ratios.  If missing, an attempt
is made to interpret \code{x} in a suitable way.}

\item{z}{A \code{\link{numeric}} vector of 208Pb/204Pb ratios.  If missing, an attempt
is made to interpret \code{x} in a suitable way.}

\item{...}{Currently not used.}

\item{t0}{A \code{\link{numeric}} value giving the time of the second stage of the
reference model.}

\item{x_star}{A \code{\link{numeric}} value giving the 206Pb/204Pb ratio at
\eqn{t = 0}.}

\item{y_star}{A \code{\link{numeric}} value giving the 207Pb/204Pb ratio at
\eqn{t = 0}.}

\item{z_star}{A \code{\link{numeric}} value giving the 208Pb/204Pb ratio at
\eqn{t = 0}.}

\item{mu}{A \code{\link{numeric}} value giving the 238U/204Pb ratio of the
reference model.}

\item{kappa}{A \code{\link{numeric}} value giving the 232Th/238U ratio of the
reference model.}

\item{th232}{A \code{\link{numeric}} value giving the decay constants of 232Th.}

\item{u238}{A \code{\link{numeric}} value giving the decay constants of 238U.}

\item{u235}{A \code{\link{numeric}} value giving the decay constants of 235U.}

\item{u238_235}{A \code{\link{numeric}} value giving the actual 238U/235U ratio.}

\item{tolerance}{A \code{\link{numeric}} value specifying the tolerance (stopping
criteria for the Newton–Raphson method).}

\item{stop}{An \code{\link{integer}} giving the stopping rule (i.e. maximum number of
iterations) to avoid infinite loop.}
}
\value{
A four columns \code{\link{data.frame}}:
\describe{
\item{\code{age}}{Geological model age (in Ma).}
\item{\code{mu}}{238U/204Pb ratio.}
\item{\code{kappa}}{232Th/238U ratio.}
\item{\code{residual}}{Newton loop residual.}
}
}
\description{
Compute geological model age (T) and U/Pb (mu) and Th/U (kappa) ratios from
lead isotopic measurements.
}
\note{
Reference values from Albarede & Juteau (1984).
}
\examples{
Pb <- data.frame(
  x = c(18.23247, 18.22936, 18.23102), # Pb206/Pb204
  y = c(15.65199, 15.65216, 15.65097), # Pb207/Pb204
  z = c(38.5167, 38.51516, 38.51601)   # Pb208/Pb204
)

## Default reference values from Albarede & Juteau (1984)
pb_age(
  Pb,
  t0 = 3.8,
  x_star = 18.75, y_star = 15.63, z_star = 38.86,
  mu = 9.66, kappa = 3.90, th232 = 0.049475,
  u238 = 0.155125, u235 = 0.98485, u238_235 = 137.79
)

## Reference values from Albarede et al. (2012)
pb_age(
  Pb,
  t0 = 4.43,
  x_star = 18.75, y_star = 15.63, z_star = 38.83,
  mu = 9.66, kappa = 3.90, th232 = 0.049475,
  u238 = 0.155125, u235 = 0.98485, u238_235 = 137.79
)
}
\references{
Albarède, F., Desaulty, A.-M. & Blichert-Toft, J. (2012). A Geological
Perspective on the Use of Pb Isotopes in Archaeometry. \emph{Archaeometry}, 54:
853-867. \doi{10.1111/j.1475-4754.2011.00653.x}.

Albarède, F. & Juteau, M. (1984). Unscrambling the Lead Model Ages.
\emph{Geochimica et Cosmochimica Acta}, 48(1): 207-12.
\doi{10.1016/0016-7037(84)90364-8}.

Allègre, C. (2005). \emph{Géologie isotopique}. Belin sup. Paris: Belin.
}
\author{
N. Frerebeau, F. Albarede (original Matlab code)
}
\concept{isotope analysis}
