% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/plot.R
\docType{methods}
\name{c14_plot}
\alias{c14_plot}
\alias{plot,CalibratedAges,missing-method}
\alias{plot,CalibratedSPD,missing-method}
\title{Plot Calibrated Radiocarbon Ages}
\usage{
\S4method{plot}{CalibratedAges,missing}(
  x,
  calendar = get_calendar(),
  density = TRUE,
  interval = c("hdr", "credible", "none"),
  level = 0.954,
  fixed = TRUE,
  decreasing = TRUE,
  col.density = "grey",
  col.interval = "#77AADD",
  main = NULL,
  sub = NULL,
  axes = TRUE,
  frame.plot = FALSE,
  ann = graphics::par("ann"),
  panel.first = NULL,
  panel.last = NULL,
  ...
)

\S4method{plot}{CalibratedSPD,missing}(
  x,
  calendar = get_calendar(),
  main = NULL,
  sub = NULL,
  ann = graphics::par("ann"),
  axes = TRUE,
  frame.plot = FALSE,
  panel.first = NULL,
  panel.last = NULL,
  ...
)
}
\arguments{
\item{x}{A \code{\linkS4class{CalibratedAges}} or \code{\linkS4class{CalibratedSPD}} object.}

\item{calendar}{An \code{\link[aion:TimeScale-class]{aion::TimeScale}} object specifying the target
calendar (see \code{\link[aion:calendar]{aion::calendar()}}). If \code{NULL}, \emph{rata die} are returned.}

\item{density}{A \code{\link{logical}} scalar: should density be drawn?}

\item{interval}{A \code{\link{character}} string specifying the intervals to be drawn.
It must be one of "\code{hrd}" (the default), "\code{credible}" or "\code{none}".
Any unambiguous substring can be given.}

\item{level}{A length-one \code{\link{numeric}} vector giving the confidence level.
Only used if \code{interval} is \code{TRUE}.}

\item{fixed}{A \code{\link{logical}} scalar: should a fixed y scale be used?
If \code{TRUE} (the default), ages are equally spaced along the y axis.
If \code{FALSE}, age \code{positions} are used (see \code{\link[=c14_calibrate]{c14_calibrate()}}).}

\item{decreasing}{A \code{\link{logical}} scalar: should the sort order be decreasing?}

\item{col.density, col.interval}{A specification for the plotting colors.}

\item{main}{A \code{\link{character}} string giving a main title for the plot.}

\item{sub}{A \code{\link{character}} string giving a subtitle for the plot.}

\item{axes}{A \code{\link{logical}} scalar: should axes be drawn on the plot?}

\item{frame.plot}{A \code{\link{logical}} scalar: should a box be drawn around the
plot?}

\item{ann}{A \code{\link{logical}} scalar: should the default annotation (title and x
and y labels) appear on the plot?}

\item{panel.first}{An an \code{expression} to be evaluated after the plot axes are
set up but before any plotting takes place. This can be useful for drawing
background grids.}

\item{panel.last}{An \code{expression} to be evaluated after plotting has taken
place but before the axes, title and box are added.}

\item{...}{Other \link[graphics:par]{graphical parameters} may also be passed as
arguments to this function.}
}
\value{
\code{plot()} is called it for its side-effects: it results in a graphic
being displayed. Invisibly returns \code{x}.
}
\description{
Plot Calibrated Radiocarbon Ages
}
\examples{
## Calibrate multiple dates
cal <- c14_calibrate(
  values = c(5000, 4500),
  errors = c(45, 35),
  names = c("X", "Y")
)

## Specify calendar
plot(cal, calendar = BP())

## HDR intervals (default)
plot(cal, interval = "hdr", level = 0.95)

## Credible intervals
plot(cal, interval = "credible", level = 0.95)

## No intervals
plot(cal, interval = NULL)

## Intervals only
plot(cal, density = FALSE, level = 0.68, lwd = 5)
plot(cal, density = FALSE, level = 0.95, lwd = 5)

## Change colors
plot(cal[, 1, ], col.interval = "red")
}
\seealso{
Other radiocarbon tools: 
\code{\link{F14C}},
\code{\link{c14_calibrate}()},
\code{\link{c14_combine}()},
\code{\link{c14_curve}()},
\code{\link{c14_ensemble}()},
\code{\link{c14_sample}()},
\code{\link{c14_spd}()},
\code{\link{c14_uncalibrate}()},
\code{\link{rec_plot}}
}
\author{
N. Frerebeau
}
\concept{radiocarbon tools}
