% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alsi.R
\name{mca_bootstrap}
\alias{mca_bootstrap}
\title{Bootstrap-Based Subspace Stability Assessment}
\usage{
mca_bootstrap(data, vars, K, B = 2000, seed = 20260123, verbose = TRUE)
}
\arguments{
\item{data}{Data frame or path to .xlsx file}

\item{vars}{Character vector of binary variable names}

\item{K}{Integer, number of dimensions to retain and assess}

\item{B}{Integer, number of bootstrap resamples (default: 2000)}

\item{seed}{Integer, random seed for reproducibility}

\item{verbose}{Logical, print progress messages}
}
\value{
S3 object of class \code{mca_bootstrap} containing:
  \item{ref}{Reference MCA fit object (class \code{mca_fit})}
  \item{K}{Number of dimensions assessed}
  \item{B}{Number of bootstrap resamples performed}
  \item{angles}{Matrix of principal angles in degrees (B x K), measuring
    subspace similarity between bootstrap and reference solutions}
  \item{tucker}{Matrix of Tucker congruence coefficients (B x K), measuring
    dimension-level similarity after Procrustes alignment}
  \item{angles_summary}{Summary statistics (median, 5th, 95th percentiles) 
    for principal angles}
  \item{tucker_summary}{Summary statistics (median, 5th, 95th percentiles) 
    for Tucker congruence coefficients}
}
\description{
Evaluates reproducibility of retained MCA dimensions via bootstrap resampling.
Quantifies stability using Procrustes principal angles (subspace-level) and
Tucker's congruence coefficients (dimension-level).
}
\examples{
\donttest{
# Using included ANR2 dataset
data(ANR2)
vars <- c("MDD", "DYS", "DEP", "PTSD", "OCD", "GAD", "ANX", "SOPH", "ADHD")
boot <- mca_bootstrap(ANR2, vars = vars, K = 3, B = 100)
print(boot)
}
}
