% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Core.R
\name{stoufferMeta}
\alias{stoufferMeta}
\title{Weighted meta-analysis of p-values via Stouffer's method}
\usage{
stoufferMeta(p, w = NULL)
}
\arguments{
\item{p}{numeric vector of p-values.}

\item{w}{numeric vector of weights.}
}
\value{
A named numeric vector with the combined Z-score and p-value in the form
          \code{c(Z, pvalue)}.
}
\description{
\code{stoufferMeta} combines multiple weighted p-values into a meta-analysis p-value
using Stouffer's Z-score method.
}
\examples{
# Define p-value and weight vectors
p <- c(0.1, 0.05, 0.3)
w <- c(5, 10, 1)

# Unweighted
stoufferMeta(p)

# Weighted
stoufferMeta(p, w)

}
