% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AminoAcids.R
\name{aliphatic}
\alias{aliphatic}
\title{Calculates the aliphatic index of amino acid sequences}
\usage{
aliphatic(seq, normalize = TRUE)
}
\arguments{
\item{seq}{vector of strings containing amino acid sequences.}

\item{normalize}{if \code{TRUE} then divide the aliphatic index of each amino acid 
sequence by the number of informative positions. Non-informative 
position are defined by the presence any character in 
\code{c("X", "-", ".", "*")}. If \code{FALSE} then return the raw
aliphatic index.}
}
\value{
A vector of the aliphatic indices for the sequence(s).
}
\description{
\code{aliphatic} calculates the aliphatic index of amino acid sequences using 
the method of Ikai. Non-informative positions are excluded, where non-informative 
is defined as any character in \code{c("X", "-", ".", "*")}.
}
\examples{
seq <- c("CARDRSTPWRRGIASTTVRTSW", NA, "XXTQMYVRT")
aliphatic(seq)

}
\references{
\enumerate{
  \item  Ikai AJ. Thermostability and aliphatic index of globular proteins. 
           J Biochem. 88, 1895-1898 (1980).
}
}
