% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_fill_continuous_af.R
\name{scale_fill_continuous_af}
\alias{scale_fill_continuous_af}
\title{Continuous colour fill scales for Analysis Function plots}
\usage{
scale_fill_continuous_af(
  palette = "sequential",
  palette_type = c("af"),
  reverse = FALSE,
  na.value = afcharts::af_pale_grey,
  guide = "colourbar",
  ...
)
}
\arguments{
\item{palette}{Name of palette to use from \code{af_colour_palettes}; e.g.
\code{"categorical"}, \code{"sequential"}, \code{"focus"}. Default value is
\code{"sequential"}.}

\item{palette_type}{Currently only the Analysis Function palettes are
supported. Defaults to "af".}

\item{reverse}{Boolean value to indicate whether the palette should be
reversed.}

\item{na.value}{Colour to set for missing values.}

\item{guide}{A name or function used to create guide. Default is "colourbar".}

\item{...}{Additional arguments passed to scale type.}
}
\value{
ggplot2 continuous fill scale
}
\description{
Continuous colour fill scales for Analysis Function plots
}
\examples{
library(ggplot2)

ggplot(faithfuld, aes(x = waiting, y = eruptions, fill = density)) +
  geom_raster() +
  scale_fill_continuous_af()

}
