% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ghg_flux.R
\name{calculate_total_co2e}
\alias{calculate_total_co2e}
\title{calculate_total_co2e}
\usage{
calculate_total_co2e(co2 = 0, ch4 = 0, n2o = 0)
}
\arguments{
\item{co2}{CO\eqn{_2} flux in mg m\eqn{^{-2}} h\eqn{^{-1}}. Default 0.}

\item{ch4}{CH\eqn{_4} flux in mg m\eqn{^{-2}} h\eqn{^{-1}}. Default 0.}

\item{n2o}{N\eqn{_2}O flux in mg m\eqn{^{-2}} h\eqn{^{-1}}. Default 0.}
}
\value{
Total CO\eqn{_2}e flux as a numeric scalar
  (g m\eqn{^{-2}} d\eqn{^{-1}}), printed with a diagnostic message.
}
\description{
Convert individual GHG fluxes (mg m\eqn{^{-2}} h\eqn{^{-1}})
  to a total CO\eqn{_2}-equivalent flux (g m\eqn{^{-2}} d\eqn{^{-1}}) using
  IPCC AR6 100-year GWPs (CO\eqn{_2} = 1, CH\eqn{_4} = 27,
  N\eqn{_2}O = 273).
}
\examples{
calculate_total_co2e(co2 = 4.02, ch4 = 0.001, n2o = 0.003)
}
