% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/amef.R
\name{amef}
\alias{amef}
\title{Estimate the average marginal effect function (AMEF)}
\usage{
amef(x, eps = 1e-05)
}
\arguments{
\item{x}{an \code{adrf_curve} object; the output of a call to \code{\link[=adrf]{adrf()}}.}

\item{eps}{numeric; the step size to use when calculating numerical derivatives. Default is \code{1e-5} (.00001). See Details.}
}
\value{
An object of class \code{amef_curve}, which inherits from \code{\link{effect_curve}}.
}
\description{
\code{amef()} computes the average marginal effect function (AMEF), the derivative of the average dose-response function (ADRF). This computed from an \code{adrf_curve} object or from a fitting outcome model directly.
}
\details{
The AMEF is calculated numerically using the central finite derivative formula:

\deqn{\frac{df(x)}{dx} \approx \frac{f(x + e) - f(x - e)}{2e}}

The values of the ADRF at the evaluation points are computed using a local polynomial regression as described at \code{\link{effect_curve}}. At the boundaries of the ADRF, one-sided derivatives are used.
}
\examples{
data("nhanes3lead")

fit <- lm(Math ~ poly(logBLL, 5) *
            Male * (Age + Race + PIR +
                      Enough_Food),
          data = nhanes3lead)

# ADRF of logBLL on Math
adrf1 <- adrf(fit, treat = "logBLL")

# AMEF of logBLL on Math
amef1 <- amef(adrf1)

amef1

# Plot the AMEF
plot(amef1)

# AMEF estimates at given points
amef1(logBLL = c(0, 1, 2)) |>
  summary()
}
\seealso{
\itemize{
\item \code{\link[=adrf]{adrf()}} for computing the ADRF
\item \code{\link[=plot.effect_curve]{plot.effect_curve()}} for plotting the AMEF
\item \code{\link[=summary.effect_curve]{summary.effect_curve()}} for testing hypotheses about the AMEF
\item \code{\link{effect_curve}} for computing point estimates along the AMEF
\item \code{\link[=curve_projection]{curve_projection()}} for projecting a simpler model onto the AMEF
\item \code{\link[=reference_curve]{reference_curve()}} for computing the difference between each point on the AMEF and a specific reference point
\item \code{\link[=curve_contrast]{curve_contrast()}} for contrasting AMEFs computed within subgroups
\item \code{\link[marginaleffects:slopes]{marginaleffects::avg_slopes()}} for computing average adjusted slopes for fitted models (similar to the AMEF)
}
}
