% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inputs.R
\name{equiv_input}
\alias{equiv_input}
\title{Create an Equivalence Vector for Each Population}
\usage{
equiv_input(mpm, stage2 = NA, stage1 = NA, age2 = NA, value = 1)
}
\arguments{
\item{mpm}{The lefkoMat object to be used in projection. Can be an example
MPM if function-based projection is planned.}

\item{stage2}{A vector showing the name or number of a stage in occasion
\emph{t} that should be set to a positive number of individuals in the start
vector. Abbreviations for groups of stages are also usable (see Notes).
This input is required for all stage-based and age-by-stage MPMs. Defaults to
\code{NA}.}

\item{stage1}{A vector showing the name or number of a stage in occasion
\emph{t}-1 that should be set to a positive number of individuals in the
start vector. Abbreviations for groups of stages are also usable (see Notes).
This is only used for historical MPMs, since the rows of hMPMs correspond to
stage-pairs in times \emph{t} and \emph{t}-1 together. Only required for
historical MPMs, and will result in errors if otherwise used.}

\item{age2}{A vector showing the age of each respective stage in occasion
\emph{t} that should be set to a positive number of individuals in the start
vector. Only used for Leslie and age-by-stage MPMs. Defaults to \code{NA}.}

\item{value}{A vector showing the values, in order, of the number of
individuals set for the stage or stage-pair in question. Defaults to
\code{1}.}
}
\value{
A list of class \code{adaptEq}, with four objects, which can be
used as input in function \code{\link{project3}()}. The last three include
the \code{ahstages}, \code{hstages}, and \code{agestages} objects from the
\code{lefkoMat} object supplied in \code{mpm}. The first element in the list
is a data frame with the following variables:

\item{stage2}{Stage at occasion \emph{t}.}
\item{stage_id_2}{The stage number associated with \code{stage2}.}
\item{stage1}{Stage at occasion \emph{t}-1, if historical. Otherwise NA.}
\item{stage_id_1}{The stage number associated with \code{stage1}.}
\item{age2}{The age of individuals in \code{stage2} and, if applicable,
\code{stage1}. Only used in age-by-stage MPMs.}
\item{row_num}{A number indicating the respective starting vector element.}
\item{value}{Number of individuals in corresponding stage or stage-pair.}
}
\description{
Function \code{equiv_input()} creates a data frame summarizing the degree to
which an individual in each stage of a life history is equivalent to a
standard individual.
}
\section{Notes}{

Entries in \code{stage2}, and \code{stage1} can include abbreviations for
groups of stages. Use \code{rep} if all reproductive stages are to be used,
\code{nrep} if all mature but non-reproductive stages are to be used,
\code{mat} if all mature stages are to be used, \code{immat} if all immature
stages are to be used, \code{prop} if all propagule stages are to be used,
\code{npr} if all non-propagule stages are to be used, \code{obs} if all
observable stages are to be used, \code{nobs} if all unobservable stages are
to be used, and leave empty or use \code{all} if all stages in stageframe are
to be used.
}

\examples{
library(lefko3)
data(cypdata)

data(cypa_data)

sizevector <- c(0, 0, 0, 0, 0, 0, 1, 2.5, 4.5, 8, 17.5)
stagevector <- c("SD", "P1", "P2", "P3", "SL", "D", "XSm", "Sm", "Md", "Lg",
  "XLg")
repvector <- c(0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1)
obsvector <- c(0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1)
matvector <- c(0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1)
immvector <- c(0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0)
propvector <- c(1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
indataset <- c(0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1)
binvec <- c(0, 0, 0, 0, 0, 0.5, 0.5, 1, 1, 2.5, 7)

cypframe_raw <- sf_create(sizes = sizevector, stagenames = stagevector,
  repstatus = repvector, obsstatus = obsvector, matstatus = matvector,
  propstatus = propvector, immstatus = immvector, indataset = indataset,
  binhalfwidth = binvec)

cycaraw_v1 <- verticalize3(data = cypdata, noyears = 6, firstyear = 2004,
  patchidcol = "patch", individcol = "plantid", blocksize = 4,
  sizeacol = "Inf2.04", sizebcol = "Inf.04", sizeccol = "Veg.04",
  repstracol = "Inf.04", repstrbcol = "Inf2.04", fecacol = "Pod.04",
  stageassign = cypframe_raw, stagesize = "sizeadded", NAas0 = TRUE,
  NRasRep = TRUE)
  
cyparaw_v1 <- verticalize3(data = cypa_data, noyears = 18, firstyear = 1994,
  individcol = "plant_id", blocksize = 2, sizeacol = "Inf.94",
  sizebcol = "Veg.94", repstracol = "Inf.94", fecacol = "Inf.94",
  stageassign = cypframe_raw, stagesize = "sizeadded", NAas0 = TRUE,
  NRasRep = TRUE)

cypsupp2r <- supplemental(stage3 = c("SD", "P1", "P2", "P3", "SL", "D", 
    "XSm", "Sm", "SD", "P1"),
  stage2 = c("SD", "SD", "P1", "P2", "P3", "SL", "SL", "SL", "rep",
    "rep"),
  eststage3 = c(NA, NA, NA, NA, NA, "D", "XSm", "Sm", NA, NA),
  eststage2 = c(NA, NA, NA, NA, NA, "XSm", "XSm", "XSm", NA, NA),
  givenrate = c(0.10, 0.20, 0.20, 0.20, 0.25, NA, NA, NA, NA, NA),
  multiplier = c(NA, NA, NA, NA, NA, NA, NA, NA, 0.5, 0.5),
  type =c(1, 1, 1, 1, 1, 1, 1, 1, 3, 3),
  stageframe = cypframe_raw, historical = FALSE)
cyp_supp_list1 <- list(cypsupp2r, cypsupp2r)

cycamatrix2r <- rlefko2(data = cycaraw_v1, stageframe = cypframe_raw, 
  year = "all", patch = "all", stages = c("stage3", "stage2", "stage1"),
  size = c("size3added", "size2added"), supplement = cypsupp2r,
  yearcol = "year2", patchcol = "patchid", indivcol = "individ")

cypamatrix2r <- rlefko2(data = cyparaw_v1, stageframe = cypframe_raw, 
  year = "all", stages = c("stage3", "stage2", "stage1"),
  size = c("size3added", "size2added"), supplement = cypsupp2r,
  yearcol = "year2", patchcol = "patchid", indivcol = "individ")

cyp_mpm_list <- list(cycamatrix2r, cypamatrix2r)

cyca2_start <- start_input(cycamatrix2r, stage2 = c("SD", "P1", "P2"),
  value = c(500, 100, 200))
cypa2_start <- start_input(cypamatrix2r, stage2 = c("SD", "P1", "P2"),
  value = c(5000, 1000, 2000))
cyp_start_list <- list(cyca2_start, cypa2_start)

cyp2_dv <- density_input(cypamatrix2r, stage3 = c("SD", "P1"),
  stage2 = c("rep", "rep"), style = c(1, 1), alpha = c(0.5, 1.2),
  beta = c(1.0, 2.0), type = c(2, 1))
cyp_dv_list <- list(cyp2_dv, cyp2_dv)

cyp_eq <- equiv_input(cycamatrix2r,
  stage2 = c("SD", "P1", "SL", "D", "XSm", "Sm", "Md", "Lg", "XLg"),
  value = c(0, 1, 1, 1, 1, 1, 1, 1, 1))

eq_list <- list(cyp_eq, cyp_eq)

cyp_comm_proj <- project3(mpms = cyp_mpm_list, starts = cyp_start_list,
  density = cyp_dv_list, times = 10)
  
summary(cyp_comm_proj)

}
