% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/general_lineplot.R
\name{general_lineplot}
\alias{general_lineplot}
\title{Generate a General Line Plot for ADNCA Dataset}
\usage{
general_lineplot(
  data,
  selected_analytes,
  selected_pcspec,
  selected_usubjids,
  colorby_var = "USUBJID",
  facet_by = NULL,
  time_scale,
  yaxis_scale,
  show_threshold = FALSE,
  threshold_value = 0,
  show_dose = FALSE,
  cycle = NULL,
  palette = NULL
)
}
\arguments{
\item{data}{A data frame containing the ADNCA dataset.}

\item{selected_analytes}{A character vector of selected analytes to be included in the plot.}

\item{selected_pcspec}{A character vector of selected matrix to be included in the plot.}

\item{selected_usubjids}{A character vector of selected unique subject identifiers (USUBJIDs)
to be included in the plot.}

\item{colorby_var}{A character string specifying the variable by which to color
the lines in the plot.}

\item{facet_by}{A character vector specifying the variables by which to facet the plot.}

\item{time_scale}{A character string specifying the time scale.
Options are "By Cycle" or other values.}

\item{yaxis_scale}{A character string specifying the x-axis scale.
Options are "Log" or other values.}

\item{show_threshold}{A boolean specifying whether to show a threshold line or not.
Default is FALSE.}

\item{threshold_value}{A numeric value to set the y value of the threshold line.
Default is 0.}

\item{show_dose}{A boolean specifying whether to show dose times as vertical lines.}

\item{cycle}{A character string or numeric value specifying the cycle to filter by
when \code{time_scale} is "By Cycle". Default is NULL.}

\item{palette}{Specification of the color palette to use for the plot.}
}
\value{
A ggplot object representing the line plot of pharmacokinetic concentration over time.
}
\description{
This function generates a line plot for an ADNCA dataset based on user-selected analytes,
subjects, and other parameters. The plot can be customized to display data on a linear or
logarithmic scale and can be filtered by cycle.
}
\details{
The function performs the following steps:a
\itemize{
\item Filters the data based on the selected analytes, matrices, and subjects.
\item Selects relevant columns and removes rows with missing concentration values.
\item Converts 'USUBJID', 'ATPTREF', and 'DOSEA' to factors.
\item Filters the data by cycle if \code{time_scale} is "By Cycle"
while creating duplicates for predose samples if needed.
\item Adjusts concentration values for logarithmic scale if \code{yaxis_scale} is "Log".
\item Generates a line plot using the \code{g_ipp} function with the specified parameters.
\item Adjusts the y-axis to logarithmic scale if \code{yaxis_scale} is "Log".
\item Adds a horizontal line for the threshold value if \code{show_threshold} is TRUE.
\item Adds vertical lines for dose times if \code{show_dose} is TRUE
and the number of subjects is less than 5.
}
}
\examples{
adnca <- read.csv(system.file("shiny/data/Dummy_data.csv", package = "aNCA"))
# Use actual values from the dummy data for the example
selected_analytes <- head(unique(adnca$ANALYTE), 1)
selected_pcspec <- head(unique(adnca$PCSPEC), 1)
selected_usubjids <- head(unique(adnca$USUBJID), 1)
plot <- general_lineplot(
  data = adnca,
  selected_analytes = selected_analytes,
  selected_pcspec = selected_pcspec,
  selected_usubjids = selected_usubjids,
  colorby_var = "ATPTREF",
  time_scale = "By Cycle",
  yaxis_scale = "Log",
  cycle = "1",
  show_threshold = TRUE,
  threshold_value = 1
)
print(plot)

}
