% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-slope_selector.R
\name{.apply_slope_rules}
\alias{.apply_slope_rules}
\title{Apply Slope Rules to Update Data}
\usage{
.apply_slope_rules(data, slopes, slope_groups)
}
\arguments{
\item{data}{A list containing concentration data (\code{data$conc$data}) with columns that
need to be updated based on the slope rules.}

\item{slopes}{A data frame containing slope rules, including \code{TYPE}, \code{RANGE},
and \code{REASON} columns. May also have grouping columns (expected to match slope_groups)}

\item{slope_groups}{A character vector specifying the group columns used for filtering.}
}
\value{
description The modified \code{data} object with updated inclusion/exclusion flags
and reasons in \code{data$conc$data}.
}
\description{
This function iterates over the given slopes and updates the \code{data$conc$data} object
by setting inclusion or exclusion flags based on the slope conditions.
}
