% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{clean_sample_data}
\alias{clean_sample_data}
\title{Clean and validate case count data for EpiEstim}
\usage{
clean_sample_data(data, start_date)
}
\arguments{
\item{data}{A data frame containing at least the columns \code{"date"} and
\code{"confirm"}. The \code{"date"} column should be of class \code{Date}, and
\code{"confirm"} should be numeric.}

\item{start_date}{A \code{Date} (or date-convertible string) indicating the
starting date for analysis. Must exist within the \code{"date"} column.}
}
\value{
A cleaned data frame filtered from \code{start_date}, starting at the
first date with non-zero confirmed cases, and containing at least 14 days
of data.
}
\description{
This function prepares case count data for use with \strong{EpiEstim} by
performing a series of validation and cleaning steps:
}
\details{
\enumerate{
\item Ensures that the input data frame has the required columns:
\code{"date"} and \code{"confirm"}.
\item Confirms that the specified \code{start_date} exists in the data and filters
the data to include only records on or after that date.
\item Removes leading days before the first non-zero confirmed case.
\item Verifies that the resulting dataset contains at least 14 valid days
(as required for estimation).
}

This function is primarily intended as a preprocessing step for EpiEstim
modeling. It combines validation checks for input structure and time coverage
with minimal data cleaning logic to ensure robust downstream estimation.
}
