% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Acoef_sh.R
\name{Acoef_sh}
\alias{Acoef_sh}
\title{Coefficient matrices of the lagged endogenous variables}
\usage{
Acoef_sh(x)
}
\arguments{
\item{x}{An object of class "varshrinkeset", generated by VARshrink().}
}
\value{
A list object with K-by-K VAR coefficient matrices
\eqn{\mathbf{A}_1, ..., \mathbf{A}_p}.
}
\description{
Returns the estimated coefficient matrices of the lagged endogenous
variables as a list of \eqn{(K \times K)} matrices.
}
\details{
Consider VAR(p) model:
\deqn{\mathbf{y}_t = \mathbf{A}_1 \mathbf{y}_{t-1} + ... + \mathbf{A}_p
\mathbf{y}_{t-p} + \mathbf{C} \mathbf{d}_t + \mathbf{e}_t.}
The function returns the \eqn{(K \times K)} matrices
\eqn{\mathbf{A}_1, ..., \mathbf{A}_p} as a list object.

This function modifies \code{vars::Acoef()} for the class "varshrinkest",
preventing redundant copying of data matrix objects.
}
\examples{
data(Canada, package = "vars")
y <- diff(Canada)
estim <- VARshrink(y, p = 2, type = "const", method = "ridge")
Acoef_sh(estim)
}
\seealso{
\code{\link[vars]{Acoef}}
}
