% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robustness_score.R
\name{robustness_score}
\alias{robustness_score}
\title{Robustness Score Under Input Perturbation}
\usage{
robustness_score(predict_fn, X, noise_level = 0.05, n_rep = 10L)
}
\arguments{
\item{predict_fn}{A function that accepts a numeric matrix (observations
in rows, features in columns) and returns a numeric vector of
predictions with length equal to \code{nrow(X)}.}

\item{X}{A numeric matrix or data.frame of input features. Rows are
observations and columns are features. Must contain at least two rows
and no missing values.}

\item{noise_level}{A positive numeric scalar controlling the magnitude
of Gaussian noise added to each feature, expressed as a fraction of
the feature's standard deviation. Default is \code{0.05} (5 percent).}

\item{n_rep}{A positive integer specifying the number of perturbation
repetitions. Default is \code{10L}.}
}
\value{
A numeric scalar between 0 and 1, where 1 indicates perfect
robustness and values near 0 indicate high sensitivity to noise.
}
\description{
Evaluates the robustness of a machine learning model by measuring how
much its predictions change when small amounts of noise are added to
the input data. A robustness score of 1 indicates that predictions are
completely unaffected by perturbations, while values near 0 indicate
high sensitivity to input noise.
}
\details{
Gaussian noise proportional to each feature's standard deviation is
added to the input data. The magnitude of the noise is controlled by
\code{noise_level}. Predictions on the perturbed data are compared to
baseline predictions using normalised mean squared error. The process
is repeated \code{n_rep} times and the average score is returned.
}
\examples{
# A simple linear prediction function
pred_fn <- function(X) X \%*\% c(1, 2, 3)
set.seed(42)
X <- matrix(rnorm(300), ncol = 3)
robustness_score(pred_fn, X, noise_level = 0.05, n_rep = 10)

# A constant prediction function is perfectly robust
const_fn <- function(X) rep(5, nrow(X))
robustness_score(const_fn, X)

}
