% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WhenFirstHit.R
\name{WhenFirstHit}
\alias{WhenFirstHit}
\title{When was a tree topology first hit?}
\usage{
WhenFirstHit(trees)
}
\arguments{
\item{trees}{A list of trees, or a \code{multiPhylo} object.}
}
\value{
\code{trees}, with a \code{firstHit} attribute listing the number of trees hit
for the first time in each search iteration.
}
\description{
Reports when each tree in a list was first found by tree search.
This information is read from the \code{firstHit} attribute if present.
If not, trees are taken to be listed in the order in which they were found,
and named according to the search iteration in which they were first hit -
the situation when trees found by \code{\link[=MaximizeParsimony]{MaximizeParsimony()}} are saved to file.
}
\examples{
library("TreeTools", quietly = TRUE)
trees <- list(
   seed_00 = as.phylo(1, 8),
   ratch1_01 = as.phylo(2, 8),
   ratch1_02 = as.phylo(3, 8),
   ratch4_44 = as.phylo(4, 8),
   final_99 = as.phylo(5, 8)
)
attr(WhenFirstHit(trees), "firstHit")
}
\seealso{
\itemize{
\item \code{\link[=MaximizeParsimony]{MaximizeParsimony()}}
}

Other utility functions: 
\code{\link{ClusterStrings}()},
\code{\link{QuartetResolution}()}
}
\author{
\href{https://smithlabdurham.github.io/}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{utility functions}
