icm_test <- function(X, n.rep = 200, score = "Identity", weight = "Gauss", 
                     ica = "JADE", strategy = "bootstrap", ncores = NULL, 
                     iseed = NULL, eps = 1e-06, maxiter = 100, g = "tanh", 
                     method = "sym", inR = FALSE, n.init = 2) {
  
  DNAME <- deparse(substitute(X))
  
  # Validate arguments
  score <- match.arg(score, c("Identity", "Rank", "VdW"))
  weight <- match.arg(weight, c("Gauss", "Laplace"))
  ica <- match.arg(ica, c("JADE", "FOBI", "fICA"))
  strategy <- match.arg(strategy, c("bootstrap", "permutation"))
  
  # Construct the method identifier
  method_id <- paste0(score, weight, ica, "_", strategy)
  
  # Execute the appropriate function based on the method identifier
  res <- switch(method_id,
                IdentityGaussJADE_bootstrap = ICAtestGauss_jade_par(X, n.rep, eps, maxiter, ncores, iseed),
                IdentityGaussFOBI_bootstrap = ICAtestGauss_fobi_par(X, n.rep, ncores, iseed),
                IdentityGaussfICA_bootstrap = ICAtestGauss_fICA_par(X, n.rep, g, method, inR, maxiter, eps, n.init, ncores, iseed),
                IdentityLaplaceJADE_bootstrap = ICAtestLap_jade_par(X, n.rep, eps, maxiter, ncores, iseed),
                IdentityLaplaceFOBI_bootstrap = ICAtestLap_fobi_par(X, n.rep, ncores, iseed),
                IdentityLaplacefICA_bootstrap = ICAtestLap_fICA_par(X, n.rep, g, method, inR, maxiter, eps, n.init, ncores, iseed),
                RankGaussJADE_bootstrap = ICAtestRankGauss_jade_par(X, n.rep, eps, maxiter, ncores, iseed),
                RankGaussFOBI_bootstrap = ICAtestRankGauss_fobi_par(X, n.rep, ncores, iseed),
                RankGaussfICA_bootstrap = ICAtestRankGauss_fICA_par(X, n.rep, g, method, inR, maxiter, eps, n.init, ncores, iseed),
                RankLaplaceJADE_bootstrap = ICAtestRankLap_jade_par(X, n.rep, eps, maxiter, ncores, iseed),
                RankLaplaceFOBI_bootstrap = ICAtestRankLap_fobi_par(X, n.rep, ncores, iseed),
                RankLaplacefICA_bootstrap = ICAtestRankLap_fICA_par(X, n.rep, g, method, inR, maxiter, eps, n.init, ncores, iseed),
                VdWGaussJADE_bootstrap = ICAtestRankvdW_jade_par(X, n.rep, eps, maxiter, ncores, iseed),
                VdWGaussFOBI_bootstrap = ICAtestRankvdW_fobi_par(X, n.rep, ncores, iseed),
                VdWGaussfICA_bootstrap = ICAtestRankvdW_fICA_par(X, n.rep, g, method, inR, maxiter, eps, n.init, ncores, iseed),
                IdentityGaussJADE_permutation = ICAtestGauss_jade_perm_par(X, n.rep, eps, maxiter, ncores, iseed),
                IdentityGaussFOBI_permutation = ICAtestGauss_fobi_perm_par(X, n.rep, ncores, iseed),
                IdentityGaussfICA_permutation = ICAtestGauss_fICA_perm_par(X, n.rep, g, method, inR, maxiter, eps, n.init, ncores, iseed),
                IdentityLaplaceJADE_permutation = ICAtestLap_jade_perm_par(X, n.rep, eps, maxiter, ncores, iseed),
                IdentityLaplaceFOBI_permutation = ICAtestLap_fobi_perm_par(X, n.rep, ncores, iseed),
                IdentityLaplacefICA_permutation = ICAtestLap_fICA_perm_par(X, n.rep, g, method, inR, maxiter, eps, n.init, ncores, iseed),
                RankGaussJADE_permutation = ICAtestRankGauss_jade_perm_par(X, n.rep, eps, maxiter, ncores, iseed),
                RankGaussFOBI_permutation = ICAtestRankGauss_fobi_perm_par(X, n.rep, ncores, iseed),
                RankGaussfICA_permutation = ICAtestRankGauss_fICA_perm_par(X, n.rep, g, method, inR, maxiter, eps, n.init, ncores, iseed),
                RankLaplaceJADE_permutation = ICAtestRankLap_jade_perm_par(X, n.rep, eps, maxiter, ncores, iseed),
                RankLaplaceFOBI_permutation = ICAtestRankLap_fobi_perm_par(X, n.rep, ncores, iseed),
                RankLaplacefICA_permutation = ICAtestRankLap_fICA_perm_par(X, n.rep, g, method, inR, maxiter, eps, n.init, ncores, iseed),
                VdWGaussJADE_permutation = ICAtestRankvdW_jade_perm_par(X, n.rep, eps, maxiter, ncores, iseed),
                VdWGaussFOBI_permutation = ICAtestRankvdW_fobi_perm_par(X, n.rep, ncores, iseed),
                VdWGaussfICA_permutation = ICAtestRankvdW_fICA_perm_par(X, n.rep, g, method, inR, maxiter, eps, n.init, ncores, iseed),
                stop("Unsupported method combination"))

  
  # Process result for 'htest' output
  METHOD <- sprintf("Test for the validity of ICM using %s, %s score, %s weight and %s",
                    ica, score, weight, strategy)
  ALTERNATIVE <- "the ICM does not hold"
  
  res$method <- METHOD
  res$data.name <- DNAME
  res$alternative <- ALTERNATIVE
  res$statistic <- c("T" = res$T)
  res$p.value <- res$pval
  parameter <- n.rep
  names(parameter) <- ifelse(strategy == "bootstrap", "replications", "permutations")
  res$parameter <- parameter
  res$T <- NULL
  res$pval <- NULL
  
  class(res) <- c("ticm", "htest")
  return(res)
}
