% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tcgaretriever_v_1_10_1.R
\name{expand_cases}
\alias{expand_cases}
\title{Samples Included in a List of Samples.}
\usage{
expand_cases(csid, dryrun = FALSE)
}
\arguments{
\item{csid}{String corresponding to a TCGA Cancer Study identifier.}

\item{dryrun}{Logical. If TRUE, all other arguments (if any) are ignored and 
a representative example is returned as output. No Internet connection is 
required for executing the operation when `dryrun` is TRUE.}
}
\value{
list containing as many elements as TCGA case lists 
available for a given TCGA Study. Each element is named after a case list identifier.
Also, each element is a character vector including all sample identifiers
(case ids) corresponding to the corresponding case list identifier.
}
\description{
Each study includes one or more "case lists". Each case list is a collection
of samples that were analyzed using one or more platforms/assays. 
It is possible to obtain a list of all sample identifiers for each
case list of interest.
}
\examples{
# Set `dryrun = FALSE` (default option) in production!
x <- expand_cases("blca_tcga", dryrun = TRUE)
lapply(x, utils::head)


}
\references{
\url{https://www.data-pulse.com/dev_site/TCGAretriever/}
}
\author{
Damiano Fantini, \email{damiano.fantini@gmail.com}
}
