% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taf.example.R
\name{taf.example}
\alias{taf.example}
\title{TAF Example}
\usage{
taf.example(name, path = ".", force = FALSE)
}
\arguments{
\item{name}{of TAF example analysis.}

\item{path}{where to create example directory. The default is the current
working directory.}

\item{force}{whether to overwrite existing directory.}
}
\value{
Full path to directory that was created.
}
\description{
Copy example analysis from TAF package.
}
\details{
Currently, the package comes with one example: \code{"linreg"}.
}
\note{
The example analysis is copied from the TAF package directory:
\preformatted{
dir(system.file("examples", package="TAF"), full=TRUE)
}
}
\examples{
\dontrun{
taf.example("linreg")
setwd("linreg")
taf.boot()
source.all()
}

}
\seealso{
\code{\link{taf.skeleton}} creates an empty TAF template.

\code{\link{linreg}} describes the \code{linreg} example.

\code{\link{TAF-package}} gives an overview of the package.
}
