% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wide2long.R
\name{wide2long}
\alias{wide2long}
\title{Convert Wide Table to Long Format}
\usage{
wide2long(x, names = c("Age", "Value"))
}
\arguments{
\item{x}{a data frame in wide format.}

\item{names}{a vector of two names for the last two columns of the resulting
data frame.}
}
\value{
A data frame.
}
\description{
Convert a table from wide format to long format.
}
\note{
TAF stores tables as data frames, usually with a year column as seen in stock
assessment reports. Although year is the most common dimension, tables may
also include area, sex, season, or other additional dimensions. The
\code{catage.wide} table provides an example of a wide table that includes
area and year as dimensions. The long format is more convenient for analysis
and producing plots.
}
\examples{
wide2long(catage.wide, names=c("Age","Catch"))

}
\seealso{
\code{\link{catage.taf}} and \code{\link{catage.wide}} describe the TAF and
wide formats.

\code{\link{taf2long}} converts a TAF table to long format.

\code{\link{TAF-package}} gives an overview of the package.
}
