% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SppTrend-package.R
\docType{package}
\name{SppTrend-package}
\alias{SppTrend-package}
\alias{SppTrend}
\title{SppTrend: Analyzing Linear Trends in Species Occurrence Data}
\description{
Provides a methodology to analyze how species occurrences change over time, particularly in relation to spatial and thermal factors. It facilitates the development of explanatory hypotheses about the impact of environmental shifts on species by analyzing historical presence data that includes temporal and geographic information. Approach described in Lobo et al., 2023 \doi{10.1002/ece3.10674}.
}
\details{
\subsection{Methodology}{

\code{SppTrend} assumes that observed species occurrences reflect a temporal sequence of changes in response to environmental drivers.

The analysis uses:
\itemize{
\item \strong{Predictors}: Sampling date (e.g., year or year-month decimals).
\item \strong{Responses}: Geographic location (latitude, longitude or elevation) and environmental factors (temperature).
}
}

\subsection{Workflow}{

\code{SppTrend} provides a structured workflow for analyzing these trends:
\enumerate{
\item \strong{Rapid diagnostic and visual summary}: Perform a quick visual diagnostic of the input data
using \code{\link{get_fast_info}}.
\item \strong{Environmental data integration (optional)}: Enhance occurrence records
with environmental context using functions like \code{\link{get_era5_tme}} (temperature)
or \code{\link{get_elevation}} (elevation).
\item \strong{Overall trend estimation}: Calculate the overall temporal trend (OT) of
selected response variables across the entire dataset using \code{\link{overall_trend}}.
This serves as a neutral reference against which species-specific temporal trends are evaluated
\item \strong{Individual trend analysis}: Estimate the species-specific temporal trends for each selected response variable
using \code{\link{spp_trend}}. This compares individual species' responses to the overall trend via interaction models.
\item \strong{Ecological strategy classification}: Classify species into distinct Spatial or Thermal response strategies based on the
direction and statistical significance of their species-specific trends relative to the overall trend using \code{\link{spp_strategy}}.
}
}

\subsection{More details}{

Source code: \url{https://github.com/MarioMingarro/SppTrend}
}
}
\author{
\strong{Maintainer}: Mario Mingarro \email{mario_mingarro@mncn.csic.es} (\href{https://orcid.org/0000-0003-3977-7944}{ORCID})

Authors:
\itemize{
  \item Emilio García-Roselló (\href{https://orcid.org/0000-0003-0305-770X}{ORCID})
  \item Jorge M. Lobo (\href{https://orcid.org/0000-0002-3152-4769}{ORCID})
}

}
\keyword{internal}
