% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bcsd.R
\name{predict.BCSD}
\alias{predict.BCSD}
\title{Predict method for BCSD model}
\usage{
\method{predict}{BCSD}(object, newdata, ...)
}
\arguments{
\item{object}{A BCSD model object, an output of the \link{bcsd} function.}

\item{newdata}{Array or raster that has the new coarse resolution data to be downscaled. The resolution should match the resolution of the training data.
The first two dimensions are the spatial dimensions and the third refers to the training samples (e.g. time).}

\item{...}{Additional arguments (not used).}
}
\value{
A matrix, array or raster of the downscaled predictions at fine resolution.
}
\description{
This function generates predictions using a trained BCSD model.
}
\details{
The predict method applies the trained BCSD model to new coarse resolution data.
It performs bias correction using the quantile mapping function and then applies
spatial interpolation, specified during model training with the \code{method} parameter,
to generate fine resolution predictions.
}
\examples{
# Simple example with random data
coarse <- array(rnorm(10*20*30), dim = c(10, 20, 30))  # time x lat x lon
fine <- array(rnorm(10*40*60), dim = c(10, 40, 60))    # time x lat x lon
model <- bcsd(coarse, fine, method = "bilinear", n_quantiles = 100)
# New coarse data for prediction
new_coarse <- array(rnorm(5*20*30), dim = c(5, 20, 30))  # time x lat x lon
predictions <- predict(model, new_coarse)
# Check dimensions of predictions
dim(predictions)  # Should be (5, 40, 60) for time x lat x lon
}
\seealso{
\code{\link{bcsd}} for training the model.
}
