% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/database.R
\name{possible_L_R_pairs_cellphoneDB}
\alias{possible_L_R_pairs_cellphoneDB}
\title{Identify Possible Ligand-Receptor Pairs for Cell-Cell Communication}
\usage{
possible_L_R_pairs_cellphoneDB(gene_spot_expression_dataframe, percentage)
}
\arguments{
\item{gene_spot_expression_dataframe}{A gene expression data frame with genes as row names and Spot IDs as column names. This data frame is used to verify the presence of all genes involved in the L-R pairs.}

\item{percentage}{A numeric value specifying the minimum percentage of spots in which a gene must be expressed to be considered. The default is 10.}
}
\value{
A list containing:
\describe{
  \item{possible_L_R_pairs}{A data frame of L-R pairs where all genes are present in the 'gene_spot_expression_dataframe' and meet the expression threshold. The data frame includes the ligand and receptor vectors, and the combined gene vectors.}
  \item{possible_L_R_pairs_details}{A data frame with detailed information about the identified L-R pairs, including their original annotations from the CellPhoneDB dataset.}
}
}
\description{
CellPhone Database: This function identifies possible ligand-receptor (L-R) pairs for cell-cell communication analysis using data from a CellPhoneDB dataset. It checks for the presence of all genes involved in each L-R pair within the provided gene expression matrix and filters based on a specified expression percentage threshold.
}
